<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Session Expired</title>
    <style>
        html, body { height: 100%; margin: 0; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Fira Sans", "Droid Sans", "Helvetica Neue", Arial, sans-serif; color: #111827; background: #F9FAFB; }
        .container { min-height: 100%; display: flex; align-items: center; justify-content: center; padding: 24px; }
        .card { width: 100%; max-width: 480px; background: #FFFFFF; border: 1px solid #E5E7EB; border-radius: 12px; box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -4px rgba(0,0,0,0.1); padding: 32px; text-align: center; }
        .icon { font-size: 48px; color: #F59E0B; margin-bottom: 16px; }
        .title { font-size: 24px; font-weight: 700; margin: 0 0 8px; color: #111827; }
        .subtitle { font-size: 16px; color: #6B7280; margin: 0 0 24px; line-height: 1.5; }
        .btn { display: inline-block; background: #3B82F6; color: #FFFFFF; text-decoration: none; padding: 12px 24px; border-radius: 8px; font-weight: 500; transition: background-color 0.2s; }
        .btn:hover { background: #2563EB; }
        .meta { margin-top: 24px; font-size: 12px; color: #6B7280; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="icon">⚠️</div>
            <h1 class="title">Session Expired</h1>
            <p class="subtitle">Your session has expired for security reasons. Please log in again to continue.</p>
            
            <a href="<?php echo e(route('login')); ?>" class="btn">Go to Login</a>
            
            <div class="meta">
                Error 419: Page Expired
            </div>
        </div>
    </div>

    <script>
        // Auto-redirect after 3 seconds
        setTimeout(function() {
            window.location.href = "<?php echo e(route('login')); ?>";
        }, 3000);
    </script>
</body>
</html>
<?php /**PATH D:\WORK\MAARIFA\ANGO\DESKTOP\V4\ango-desktop\resources\views/errors/419.blade.php ENDPATH**/ ?>