<div>
    <main class="container mx-auto" x-data="{ showCreateUserModal: false }">

        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Utilisateurs' => null,
        ]">
            <x-slot name="action">
                <div class="flex space-x-3">
                    <x-basics.button @click="showCreateUserModal = true">
                        <i class="ph ph-plus mr-2"></i>
                        Ajouter un utilisateur
                    </x-basics.button>
                </div>
            </x-slot>
        </x-dashboard.breadcrumb>

        <div class="mt-6">

            <!-- Users Table -->
            <div class="bg-white border border-gray-300 rounded overflow-hidden shadow-sm mb-8">

                <div class="p-4 border-b">
                    <h4 class="font-semibold text-gray-800">Liste des utilisateurs</h4>
                    <p class="text-sm text-gray-500">Voir la liste de tous les utilisateurs</p>
                </div>
                <div class="overflow-x-auto">
                    @if ($users->count() > 0)
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Nom</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Username</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Email</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Rôle</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $user)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2 font-medium">
                                            {{ ($users->currentPage() - 1) * $users->perPage() + $loop->iteration }}.
                                        </td>
                                        <td class="px-3 py-2">
                                            <x-basics.link size="normal" href="{{ route('users.show', $user) }}">
                                                {{ $user->firstname }} {{ $user->lastname }}
                                            </x-basics.link>
                                        </td>
                                        <td class="px-3 py-2 text-gray-900 font-medium">
                                            {{ $user->username }}
                                        </td>
                                        <td class="px-3 py-2 text-gray-900 font-medium">
                                            {{ $user->email }}
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">
                                            {!! $user->role_badge !!}
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">
                                            {!! $user->status_badge !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if ($users->hasPages())
                            <div class="p-4 border-t bg-gray-50">
                                {{ $users->onEachSide(1)->links() }}
                            </div>
                        @endif
                    @else
                        <div class="text-center py-12">
                            <div class="text-gray-500">
                                <i class="ph ph-users text-4xl mb-4"></i>
                                <p class="text-lg font-medium">Aucun utilisateur trouvé</p>
                            </div>
                        </div>
                    @endif
                </div>

            </div>

        </div>

        <form action="{{ route('users.store') }}" method="POST">
            <x-basics.modal id="createUserModal" title="Ajouter un utilisateur" show="showCreateUserModal">
                @csrf
                <div class="space-y-4">
                    <x-basics.input name="firstname" label="Prénom" placeholder="Entrez votre prénom" required
                        minlength="3"/>

                    <x-basics.input name="lastname" label="Nom" placeholder="Entrez votre nom de famille" required
                        minlength="3"/>

                    <x-basics.input type="email" name="email" label="Adresse email"
                        placeholder="Entrez l'adresse email" required />

                    @php
                        $raw = App\Models\User::ROLES;
                        $items = is_string($raw) ? (json_decode($raw, true) ?: []) : (array) $raw;

                        $roles = collect($items)
                            ->map(function ($role) {
                                // Normalize each item to an object with id/name
                                if (is_string($role)) {
                                    return (object) ['id' => $role, 'name' => ucfirst($role)];
                                }
                                if (is_array($role)) {
                                    return (object) [
                                        'id' => $role['id'] ?? ($role['slug'] ?? null),
                                        'name' => $role['name'] ?? ($role['label'] ?? null),
                                    ];
                                }
                                return null;
                            })
                            ->filter(fn($r) => $r && $r->id && $r->name && $r->id !== 'owner')
                            ->values();
                    @endphp

                    <x-basics.select name="role" label="Rôle" placeholder="Sélectionnez le rôle" required
                        :options="$roles" />

                </div>

                @slot('footer')
                    <x-basics.button type="submit" variant="primary" class="w-full">
                        Ajouter l'utilisateur
                    </x-basics.button>
                @endslot


            </x-basics.modal>
        </form>

</div>
