<div class="container mx-auto space-y-6" x-data="{ showCreateUnitModal: false }">

    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Unités de mesure' => null,
    ]">
        <x-slot name="action">
            <x-basics.button @click="showCreateUnitModal = true">
                <i class="ph ph-plus mr-2"></i>
                Nouvelle unité
            </x-basics.button>
        </x-slot>
    </x-dashboard.breadcrumb>
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4"></div>

    <!-- Search and Filters -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form method="GET" action="{{ route('units.index') }}" class="flex flex-col sm:flex-row gap-4">
            <div class="flex-1">
                <x-basics.input name="search" placeholder="Rechercher une unité..." value="{{ request('search') }}" />
            </div>

            <div class="flex items-center gap-3">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Rechercher
                </x-basics.button>
                @if (request('search'))
                    <x-basics.button-link href="{{ route('units.index') }}" variant="outline">
                        <i class="ph ph-x mr-2"></i>
                        Reset
                    </x-basics.button-link>
                @endif
            </div>
        </form>
    </div>

    <!-- Units List -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Liste des unités</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($units->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Unité</th>
                            <th class="p-3 text-left font-medium text-gray-700">Description</th>
                            <th class="p-3 text-left font-medium text-gray-700 w-10 text-end">Produits</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($units as $unit)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2">
                                    {{ ($units->currentPage() - 1) * $units->perPage() + $loop->iteration }}.</td>
                                <td class="px-3 py-2">
                                    <x-basics.link size=""
                                        href="{{ route('units.show', $unit) }}">{{ $unit->name }}</x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    @if ($unit->description)
                                        {{ Str::limit($unit->description, 80) }}
                                    @else
                                        <span class="text-gray-400">Aucune description</span>
                                    @endif
                                </td>
                                <td class="px-3 py-2 text-end">{{ $unit->products_count ?? 0 }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <!-- Pagination -->
                @if ($units->hasPages())
                    <div class="mt-6 px-4 pb-4">
                        {{ $units->links() }}
                    </div>
                @endif
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-ruler text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucune unité de mesure trouvée</p>
                        <p class="text-sm">Commencez par créer votre première unité de mesure</p>
                        <div class="mt-4">
                            <x-basics.button @click="showCreateUnitModal = true">
                                <i class="ph ph-plus mr-2"></i>
                                Créer une unité
                            </x-basics.button>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Create Unit Modal -->
    <form action="{{ route('units.store') }}" method="POST">
        @csrf
        <x-basics.modal show="showCreateUnitModal" title="Créer une unité" description="Configurez l'unité de mesure">
            <x-basics.input name="name" label="Nom" placeholder="Ex. Comprimé" :error="$errors->first('name')" class="mb-4"
                required />
            <x-basics.input name="symbol" label="Symbole" placeholder="Ex. cp" :error="$errors->first('symbol')" class="mb-4"
                required />
            @slot('footer')
                <div class="flex justify-end">
                    <x-basics.button type="submit" class="w-full">
                        Ajouter l'unité
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
</div>
