<div>
    <main class="container mx-auto" x-data="{ showCreateSubscriptionModal: false }">

        <x-breadcrumb title="Abonnements" :items="[
            'Dashboard' => route('home'),
            'Abonnements' => null,
        ]">
            <x-slot name="action">
                <div class="flex space-x-3">
                    <x-basics.button @click="showCreateSubscriptionModal = true">
                        <i class="ph ph-plus mr-2"></i>
                        Activer un abonnement
                    </x-basics.button>
                </div>
            </x-slot>
        </x-breadcrumb>

        <div class="mt-6">

            <!-- Recent Subscriptions Table -->
            <div class="bg-white border border-gray-300 rounded overflow-hidden shadow-sm mb-8">
                
                <div class="p-4 border-b">
                    <h4 class="font-semibold text-gray-800">Liste des abonnements</h4>
                    <p class="text-sm text-gray-500">Voir la liste de tous les abonnements</p>
                </div>
                <div class="overflow-x-auto">
                    @if ($subscriptions->count() > 0)
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                    <th class="p-3 text-left font-medium text-gray-700">
                                        Code d'abonnement
                                    </th>
                                    <th class="p-3 text-left font-medium text-gray-700">Catégorie</th>
                                    <th class="p-3 text-left font-medium text-gray-700">
                                        Date d'activation
                                    </th>
                                    <th class="p-3 text-left font-medium text-gray-700">Date de fin</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($subscriptions as $subscription)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2 font-medium">{{ $loop->iteration }}.</td>
                                        <td class="px-3 py-2">
                                            <x-basics.link size="normal"
                                                href="{{ route('subscriptions.show', $subscription) }}">
                                                {{ $subscription->code ?? 'N/A' }}
                                            </x-basics.link>
                                        </td>
                                        <td class="px-3 py-2 text-gray-900 font-medium">
                                            {{ $subscription->category }}
                                        </td>

                                        <td class="px-3 py-2 text-gray-600">
                                            {{ $subscription->activated_at ? $subscription->activated_at->format('d/m/Y H:i') : 'N/A' }}
                                        </td>

                                        <td class="px-3 py-2">
                                            {!! $subscription->end_date->format('d/m/Y') !!}
                                        </td>

                                        <td class="px-3 py-2 text-gray-600">
                                            {!! $subscription->status_badge !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if ($subscriptions->hasPages())
                            <div class="p-4 border-t bg-gray-50">
                                {{ $subscriptions->onEachSide(1)->links() }}
                            </div>
                        @endif
                    @else
                        <div class="text-center py-12">
                            <div class="text-gray-500">
                                <i class="ph ph-credit-card text-4xl mb-4"></i>
                                <p class="text-lg font-medium">Aucun abonnement trouvé</p>
                            </div>
                        </div>
                    @endif
                </div>

            </div>

        </div>


        <x-basics.modal id="createSubscriptionModal" title="Activer un abonnement" show="showCreateSubscriptionModal">
            <form action="{{ route('subscriptions.store') }}" method="POST">
                @csrf
                <div class="mb-6">
                    <x-basics.input name="code" label="Code d'activation de l'abonnement"
                        placeholder="Entrez le code d'activation (12-15 caractères)" required minlength="12"
                        maxlength="15" />
                </div>
                <div class="flex justify-end space-x-3">
                    <x-basics.button type="submit" variant="primary" class="w-full">
                        Activer l'abonnement
                    </x-basics.button>
                </div>
            </form>
        </x-basics.modal>

    </main>
</div>
