<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Entrées de stock' => route('stock-entries.index'),
        $stockEntry->batch_no => null,
    ]">

        <x-slot name="action">
            <x-dashboard.stock-entries.dropdown :stockEntry="$stockEntry" />
        </x-slot>

    </x-dashboard.breadcrumb>

    <div class="flex gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Détails de l'Entrée de Stock" subtitle="Informations complètes sur l'entrée de stock">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Product -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-package text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Produit</h3>
                                <p class="text-sm text-gray-600">{{ $stockEntry->product->name ?? 'Produit supprimé' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Supplier -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-buildings text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Fournisseur</h3>
                                <p class="text-sm text-gray-600">{{ $stockEntry->supplier?->name ?? 'Aucun fournisseur' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Batch Number -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-hash text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Numéro de lot</h3>
                                <p class="text-sm text-gray-600">{{ $stockEntry->batch_no }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Expiry Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar-x text-orange-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Date d'expiration</h3>
                                @if ($stockEntry->expiry_date)
                                    <div class="flex items-center gap-2">
                                        <p class="text-sm text-gray-600">{{ $stockEntry->expiry_date->format('d/m/Y') }}</p>
                                        <div>{!! $stockEntry->getExpiryStatusBadge() !!}</div>
                                    </div>
                                @else
                                    <p class="text-sm text-gray-600">Aucune date d'expiration</p>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Quantity -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-cyan-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-warehouse text-cyan-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Quantité</h3>
                                <p class="text-sm text-gray-600">{{ number_format($stockEntry->quantity) }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Remaining Quantity -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-emerald-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-package-plus text-emerald-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Quantité restante</h3>
                                <p class="text-sm text-gray-600">{{ number_format($stockEntry->remaining_quantity) }}</p>
                            </div>
                        </div>
                    </div>

                    @if ($stockEntry->purchase_price)
                        <!-- Unit Price -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-currency-dollar text-red-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Prix unitaire</h3>
                                    <p class="text-sm text-gray-600">
                                        {{ number_format($stockEntry->purchase_price, 2) }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Total Amount -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-indigo-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-calculator text-indigo-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Montant total</h3>
                                    <p class="text-sm text-gray-600">
                                        {{ number_format($stockEntry->getTotalAmount(), 2) }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                @if ($stockEntry->notes)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Notes</h3>
                                <p class="text-sm text-gray-600">{{ $stockEntry->notes }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>

        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.stock-entries.sidebar :stockEntry="$stockEntry" />
        </div>
    </div>
</div>
