@extends('layouts.dashboard', ['title' => 'Modifier l\'entrée de stock', 'current' => 'stock-entries-index'])

@section('content')
    <div class="min-h-screen">
        <main class="container mx-auto flex flex-col lg:flex-row gap-6 my-6">

            <!-- Main Content -->
            <div class="w-full lg:w-8/12 space-y-6">

                <!-- Breadcrumb -->
                <x-dashboard.breadcrumb-min :items="[
                    'Dashboard' => route('home'),
                    'Entrées de stock' => route('stock-entries.index'),
                    'Modifier' => null,
                ]" />

                <!-- Stock Entry Information -->
                <livewire:stock-entries.edit-general :stockEntry="$stockEntry" />

            </div>

            <!-- Sidebar -->
            <div class="w-full lg:w-4/12 space-y-6">
                <x-dashboard.stock-entries.sidebar :stockEntry="$stockEntry" />

                <!-- Help Section -->
                <x-basics.card title="Indications" bodyBg="bg-orange-50">
                    <div class="space-y-3 text-sm">
                        <p class="text-gray-600 text-justify">
                            <strong>· Le Produit</strong> détermine quel article est ajouté au stock.
                        </p>
                        <p class="text-gray-600 text-justify">
                            <strong>· La Quantité</strong> indique le nombre d'unités ajoutées.
                        </p>
                        <p class="text-gray-600 text-justify">
                            <strong>· Le Type de source</strong> indique l'origine de l'entrée (achat, ajustement, etc.).
                        </p>
                        <p class="text-gray-600 text-justify">
                            <strong>· La Date d'expiration</strong> est importante pour la gestion des produits périssables.
                        </p>
                    </div>
                </x-basics.card>
            </div>

        </main>
    </div>
@endsection
