<div class="container mx-auto" x-data>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Ajustements de stock' => route('stock-adjustments.index'),
        $adjustment->reference => null,
    ]">
        <x-slot name="action">
            <x-dashboard.stock-adjustments.dropdown :adjustment="$adjustment" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Informations de l'ajustement" subtitle="Détails de l'ajustement">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Reference -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-hash text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Référence</h3>
                                <p class="text-sm text-gray-600">{{ $adjustment->reference }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Type -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-arrow-elbow-right text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Type</h3>
                                <p class="text-sm text-gray-600">{{ $adjustment->getTypeName() }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-info text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Statut</h3>
                                <div class="text-sm">{{ $adjustment->getStatusName() }}</div>
                            </div>
                        </div>
                    </div>

                    <!-- Created Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar text-orange-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Créé le</h3>
                                <p class="text-sm text-gray-600">{{ $adjustment->created_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                @if ($adjustment->reason)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-question text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Raison</h3>
                                <p class="text-sm text-gray-600">{{ $adjustment->reason }}</p>
                            </div>
                        </div>
                    </div>
                @endif

                @if ($adjustment->notes)
                    <div class="mt-6 bg-blue-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Notes</h3>
                                <p class="text-sm text-gray-600">{{ $adjustment->notes }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>

            <x-basics.card title="Articles de l'ajustement" subtitle="Liste des produits affectés">
                @if ($adjustment->items && $adjustment->items->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Produit</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Quantité</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($adjustment->items as $item)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2">{{ $loop->iteration }}.</td>
                                        <td class="px-3 py-2">{{ $item->product?->name ?? '—' }}</td>
                                        <td class="px-3 py-2 text-gray-600">{{ $item->quantity }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-8">
                        <div class="text-gray-500">
                            <i class="ph ph-package text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucun article</p>
                            <p class="text-sm">Les articles de cet ajustement apparaîtront ici</p>
                        </div>
                    </div>
                @endif
            </x-basics.card>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.stock-adjustments.sidebar :adjustment="$adjustment" />
        </div>
    </div>
</div>
