<div class="container mx-auto" x-data="{ showCreateSaleModal: false }">

    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Ventes' => null,
    ]">
        <x-slot name="action">
            <x-basics.button-link href="{{ route('sales.create') }}">
                <i class="ph ph-plus mr-2"></i>
                Nouvelle vente
            </x-basics.button-link>
        </x-slot>
    </x-dashboard.breadcrumb>

    <!-- Filters Section -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form action="{{ route('sales.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <x-basics.input name="search" label="Rechercher..." placeholder="Nom du client ou numéro de vente..."
                    value="{{ request('search') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.select name="status" label="Statut" placeholder="Tous" :options="$statusOptions" optionLabel="label" optionValue="value"
                    value="{{ request('status') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.input name="date_from" label="Date de début" type="date"
                    value="{{ request('date_from') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.input name="date_to" label="Date de fin" type="date" value="{{ request('date_to') }}"
                    mb="0" />
            </div>

            <div class="flex gap-2">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Filtrer
                </x-basics.button>
                @if (request('search') || request('status') || request('date_from') || request('date_to'))
                    <x-basics.button-link href="{{ route('sales.index') }}" variant="outline">
                        <i class="ph ph-arrow-clockwise mr-2"></i>
                        Reset
                    </x-basics.button-link>
                @endif
            </div>
        </form>
    </div>

    <!-- Sales Table -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Liste des ventes</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($sales->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Numéro</th>
                            <th class="p-3 text-left font-medium text-gray-700">Client</th>
                            <th class="p-3 text-left font-medium text-gray-700">Montant total</th>
                            <th class="p-3 text-left font-medium text-gray-700">Méthode de paiement</th>
                            <th class="p-3 text-left font-medium text-gray-700">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($sales as $sale)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration + ($sales->currentPage() - 1) * $sales->perPage() }}.
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link href="{{ route('sales.show', $sale) }}" wire:navigate size="md">
                                        {{ $sale->sale_number ?? '—' }}
                                    </x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $sale->customer?->name ?? 'Client comptoir' }}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ number_format($sale->total_amount, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $sale->paymentMethod?->name ?? '—' }}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $sale->created_at ? \Carbon\Carbon::parse($sale->created_at)->format('d/m/Y') : '—' }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-receipt text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucune vente trouvée</p>
                        <p class="text-sm">Commencez par créer votre première vente</p>
                    </div>
                </div>
            @endif
        </div>

        @if ($sales->hasPages())
            <div class="px-4 py-4 border-t">
                {{ $sales->links() }}
            </div>
        @endif
    </div>
</div>
