<div>
    <main class="container mx-auto" x-data="{ showCreateModal: false }">

        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Types de ventes' => null,
        ]">
            <x-slot name="action">
                <div class="flex items-center gap-2">
                    <x-basics.button @click="showCreateModal = true">
                        <i class="ph ph-plus mr-2"></i>
                        Nouveau type
                    </x-basics.button>
                </div>
            </x-slot>
        </x-dashboard.breadcrumb>

        <div class="mt-6">
            <div class="bg-white border border-gray-300 rounded overflow-hidden shadow-sm mb-8">
                <div class="p-4 border-b">
                    <h4 class="font-semibold text-gray-800">Liste des types de ventes</h4>
                    <p class="text-sm text-gray-500">Voir la liste de tous les types de ventes</p>
                </div>
                <div class="overflow-x-auto">
                    @if ($saleTypes->count() > 0)
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Nom</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Description</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($saleTypes as $saleType)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2 font-medium">
                                            {{ ($saleTypes->currentPage() - 1) * $saleTypes->perPage() + $loop->iteration }}.
                                        </td>
                                        <td class="px-3 py-2">
                                            <x-basics.link size="normal"
                                                href="{{ route('sale-types.show', $saleType) }}">
                                                {{ $saleType->name }}
                                            </x-basics.link>
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">
                                            {{ Str::limit($saleType->description ?? '—', 75) }}</td>
                                        <td class="px-3 py-2">{!! $saleType->status_badge !!}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if ($saleTypes->hasPages())
                            <div class="p-4 border-t bg-gray-50">
                                {{ $saleTypes->onEachSide(1)->links() }}
                            </div>
                        @endif
                    @else
                        <div class="text-center py-12">
                            <div class="text-gray-500">
                                <i class="ph ph-tag text-4xl mb-4"></i>
                                <p class="text-lg font-medium">Aucun type de vente trouvé</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Create Modal -->
        <form method="POST" action="{{ route('sale-types.store') }}">
            @csrf
            <x-basics.modal show="showCreateModal" title="Nouveau type de vente"
                description="Créer un nouveau type de vente">
                <div class="mb-4">
                    <x-basics.input name="name" label="Nom" value="{{ old('name') }}" required />
                </div>
                @slot('footer')
                    <x-basics.button type="submit" variant="primary" class="w-full">
                        Ajouter le type de vente
                    </x-basics.button>
                @endslot
            </x-basics.modal>
        </form>
</div>
