<div>
    <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Rapports' => route('reports.business-intelligence'),
            'Rapport de Stock' => route('reports.stock-report'),
            'Guide d\'interprétation' => null,
        ]" />

    <div class="mt-6 space-y-6">
        <!-- Introduction -->
        <x-basics.card title="📦 Guide d'Interprétation - Rapport de Stock"
            subtitle="Comprendre et utiliser efficacement votre rapport de stock">
            <div class="prose max-w-none">
                <p class="text-gray-700">
                    Le Rapport de Stock vous donne une vue complète et en temps réel de votre inventaire. Ce guide vous
                    aidera à interpréter les différentes métriques et à prendre des décisions éclairées pour une
                    gestion optimale de votre stock.
                </p>
            </div>
        </x-basics.card>

        <!-- Key Metrics -->
        <x-basics.card title="📊 Indicateurs Clés" subtitle="Comprendre les métriques principales">
            <div class="space-y-4">
                <div class="border-l-4 border-blue-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Total Produits</h4>
                    <p class="text-sm text-gray-700">
                        Le nombre total de produits actifs dans votre inventaire. Un nombre élevé indique une large
                        gamme de produits, tandis qu'un nombre faible peut suggérer une spécialisation.
                    </p>
                </div>

                <div class="border-l-4 border-green-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Valeur du Stock</h4>
                    <p class="text-sm text-gray-700">
                        La valeur totale de votre inventaire basée sur le prix d'achat × quantité en stock. Cette
                        métrique est cruciale pour évaluer votre capital immobilisé et planifier vos finances.
                    </p>
                </div>

                <div class="border-l-4 border-orange-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Stock Faible</h4>
                    <p class="text-sm text-gray-700">
                        Nombre de produits dont le stock actuel est égal ou inférieur au niveau de réapprovisionnement défini. Ces
                        produits nécessitent une attention immédiate pour éviter les ruptures.
                    </p>
                    <p class="text-xs text-orange-600 mt-1">
                        ⚠️ Action recommandée: Passez une commande auprès de vos fournisseurs.
                    </p>
                </div>

                <div class="border-l-4 border-red-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">En Rupture</h4>
                    <p class="text-sm text-gray-700">
                        Nombre de produits avec un stock de 0 ou moins. Ces produits ne peuvent plus être vendus et
                        représentent des ventes perdues potentielles.
                    </p>
                    <p class="text-xs text-red-600 mt-1">
                        🚨 Action urgente: Réapprovisionnez immédiatement ces produits si la demande existe.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Table Columns Explained -->
        <x-basics.card title="📋 Colonnes du Tableau" subtitle="Comprendre chaque colonne du rapport">
            <div class="space-y-4">
                <div class="border-l-4 border-indigo-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Produit</h4>
                    <p class="text-sm text-gray-700">
                        Le nom du produit. Cliquez dessus pour voir les détails complets du produit.
                    </p>
                </div>

                <div class="border-l-4 border-purple-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">SKU</h4>
                    <p class="text-sm text-gray-700">
                        <strong>Stock Keeping Unit</strong> - Identifiant unique pour chaque produit (comme un code-barres).
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Quand créé :</strong> Lors de la création du produit dans le système</p>
                        <p><strong>Format :</strong> Généralement "PAR-500-001" (Code produit + dosage + variante)</p>
                        <p><strong>Utilité :</strong> Identification rapide, suivi d'inventaire, commandes</p>
                    </div>
                </div>

                <div class="border-l-4 border-blue-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Stock Actuel</h4>
                    <p class="text-sm text-gray-700">
                        La quantité actuellement disponible en stock, avec l'unité de mesure.
                    </p>
                </div>

                <div class="border-l-4 border-green-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Coût Unitaire</h4>
                    <p class="text-sm text-gray-700">
                        Le prix que VOUS avez payé pour acheter ce produit auprès du fournisseur.
                    </p>
                </div>

                <div class="border-l-4 border-yellow-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Valeur Stock</h4>
                    <p class="text-sm text-gray-700">
                        L'argent total immobilisé dans ce produit = Coût Unitaire × Quantité
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Exemple :</strong> Si vous avez acheté 100 comprimés à 2,500 XAF chacun</p>
                        <p><strong>Résultat :</strong> Votre "Valeur Stock" = 250,000 XAF</p>
                    </div>
                </div>

                <div class="border-l-4 border-red-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Statut</h4>
                    <p class="text-sm text-gray-700">
                        L'état du stock avec un code couleur pour une identification rapide.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Stock Status -->
        <x-basics.card title="🚦 Statuts de Stock" subtitle="Comprendre les codes couleur">
            <div class="space-y-3">
                <div class="flex items-start gap-3">
                    <span
                        class="inline-flex items-center px-3 py-1 rounded text-sm font-medium bg-green-100 text-green-800 border border-green-500">
                        <i class="ph ph-check-circle mr-1"></i>
                        En stock
                    </span>
                    <p class="text-sm text-gray-700 flex-1">
                        Le produit a un stock suffisant, supérieur au minimum défini. Aucune action requise.
                    </p>
                </div>

                <div class="flex items-start gap-3">
                    <span
                        class="inline-flex items-center px-3 py-1 rounded text-sm font-medium bg-orange-100 text-orange-800 border border-orange-500">
                        <i class="ph ph-warning mr-1"></i>
                        Stock faible
                    </span>
                    <p class="text-sm text-gray-700 flex-1">
                        Le stock est égal ou inférieur au minimum. Planifiez un réapprovisionnement rapidement.
                    </p>
                </div>

                <div class="flex items-start gap-3">
                    <span
                        class="inline-flex items-center px-3 py-1 rounded text-sm font-medium bg-red-100 text-red-800 border border-red-500">
                        <i class="ph ph-x-circle mr-1"></i>
                        Rupture
                    </span>
                    <p class="text-sm text-gray-700 flex-1">
                        Le produit n'est plus disponible. Action urgente requise pour éviter la perte de ventes.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Filters -->
        <x-basics.card title="🔍 Utiliser les Filtres" subtitle="Affiner votre analyse">
            <div class="space-y-4">
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <h4 class="font-semibold text-blue-900 mb-2">📍 Comment accéder aux filtres :</h4>
                    <ol class="list-decimal list-inside space-y-1 text-sm text-blue-800">
                        <li>Cliquez sur le menu <strong>⋮</strong> (trois points) en haut à droite du rapport</li>
                        <li>Sélectionnez <strong>"Filtrer"</strong> dans le menu déroulant</li>
                        <li>Choisissez le statut souhaité dans la fenêtre qui s'ouvre</li>
                        <li>Cliquez sur <strong>"Filtrer"</strong> pour appliquer</li>
                    </ol>
                </div>

                <div>
                    <h4 class="font-semibold text-gray-900 mb-2">Filtre par Statut</h4>
                    <p class="text-sm text-gray-700">
                        Concentrez-vous sur les produits nécessitant une attention particulière :
                    </p>
                    <ul class="list-disc list-inside mt-2 space-y-1 text-sm text-gray-600">
                        <li><strong>Tous les produits :</strong> Vue complète de votre inventaire</li>
                        <li><strong>En stock :</strong> Produits avec stock suffisant</li>
                        <li><strong>Stock faible :</strong> Produits nécessitant un réapprovisionnement</li>
                        <li><strong>En rupture :</strong> Produits avec stock à zéro</li>
                    </ul>
                </div>
            </div>
        </x-basics.card>

        <!-- Best Practices -->
        <x-basics.card title="✨ Bonnes Pratiques" subtitle="Optimiser votre gestion de stock">
            <div class="space-y-3">
                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Consultez régulièrement:</strong> Vérifiez ce rapport au moins une fois par semaine
                        pour anticiper les ruptures.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Définissez des seuils de réapprovisionnement réalistes:</strong> Ajustez les niveaux de réapprovisionnement en fonction de la demande réelle et des délais de livraison.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Priorisez les actions:</strong> Traitez d'abord les ruptures, puis les stocks faibles,
                        en tenant compte de la popularité des produits.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Exportez pour analyse:</strong> Utilisez l'export Excel pour des analyses
                        approfondies et le partage avec votre équipe.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Surveillez la valeur du stock:</strong> Une valeur trop élevée peut indiquer un
                        surstockage, tandis qu'une valeur trop faible peut signaler des opportunités manquées.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Actions -->
        <x-basics.card title="⚡ Actions Recommandées" subtitle="Que faire après avoir consulté ce rapport?">
            <div class="space-y-4">
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <h4 class="font-semibold text-blue-900 mb-2">Pour les produits en rupture:</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-blue-800">
                        <li>Contactez immédiatement le fournisseur pour passer commande</li>
                        <li>Créez un bon de commande dans le système</li>
                        <li>Informez vos clients réguliers du délai de réapprovisionnement</li>
                    </ul>
                </div>

                <div class="bg-orange-50 border border-orange-200 rounded-lg p-4">
                    <h4 class="font-semibold text-orange-900 mb-2">Pour les produits à stock faible:</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-orange-800">
                        <li>Planifiez une commande dans les prochains jours</li>
                        <li>Vérifiez les ventes récentes pour ajuster la quantité à commander</li>
                        <li>Groupez les commandes par fournisseur pour optimiser les coûts</li>
                    </ul>
                </div>

                <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                    <h4 class="font-semibold text-green-900 mb-2">Pour optimiser votre inventaire:</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-green-800">
                        <li>Identifiez les produits à rotation lente pour envisager des promotions</li>
                        <li>Comparez avec le rapport de ventes pour aligner stock et demande</li>
                        <li>Ajustez les niveaux de réapprovisionnement basés sur l'historique de ventes</li>
                    </ul>
                </div>
            </div>
        </x-basics.card>

    </div>
</div>

