<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rapport de Performance des Ventes - Impression</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            background-color: #ffffff;
            padding: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #3b82f6;
            padding-bottom: 20px;
        }
        
        .header h1 {
            color: #1e40af;
            font-size: 24px;
            margin: 0 0 10px 0;
            font-weight: bold;
        }
        
        .header .period {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
            font-weight: 500;
        }
        
        .header .generated {
            color: #9ca3af;
            font-size: 11px;
        }
        
        .section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .section-header {
            background-color: #3b82f6;
            color: white;
            padding: 10px 15px;
            margin: 0 0 0 0;
            font-size: 14px;
            font-weight: bold;
        }
        
        .section-content {
            padding: 0;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
            background-color: white;
        }
        
        th, td {
            padding: 10px 12px;
            text-align: left;
            border: 1px solid #e2e8f0;
            font-size: 11px;
        }
        
        th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        td {
            color: #1e293b;
        }
        
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        
        tr:nth-child(odd) {
            background-color: #ffffff;
        }
        
        .metric-table {
            margin-bottom: 20px;
        }
        
        .metric-table th {
            background-color: #1e40af;
            width: 50%;
        }
        
        .metric-table td {
            font-weight: 600;
            color: #1e40af;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: 600;
        }
        
        .badge-success {
            background-color: #d1fae5;
            color: #065f46;
        }
        
        .badge-danger {
            background-color: #fee2e2;
            color: #991b1b;
        }
        
        .badge-info {
            background-color: #dbeafe;
            color: #1e40af;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e2e8f0;
            text-align: center;
            color: #6b7280;
            font-size: 10px;
        }
        
        /* Print-specific styles */
        @media print {
            body {
                padding: 10px;
            }
            
            .no-print {
                display: none !important;
            }
            
            .section {
                page-break-inside: avoid;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            
            thead {
                display: table-header-group;
            }
            
            tfoot {
                display: table-footer-group;
            }
        }
        
        /* Screen-only print button */
        @media screen {
            .print-button {
                position: fixed;
                top: 20px;
                right: 20px;
                padding: 12px 24px;
                background-color: #3b82f6;
                color: white;
                border: none;
                border-radius: 8px;
                font-size: 14px;
                font-weight: 600;
                cursor: pointer;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                z-index: 1000;
            }
            
            .print-button:hover {
                background-color: #2563eb;
            }
        }
    </style>
</head>
<body>
    <!-- Print Button (visible on screen only) -->
    <button onclick="window.print()" class="print-button no-print">
        <i class="ph ph-printer"></i> Imprimer
    </button>

    <!-- Header -->
    <div class="header">
        <h1>RAPPORT DE PERFORMANCE DES VENTES</h1>
        <div class="period">
            Période : {{ $dateFrom->format('d/m/Y') }} - {{ $dateTo->format('d/m/Y') }}
        </div>
        <div class="generated">
            Généré le {{ now()->format('d/m/Y à H:i') }}
        </div>
    </div>

    <!-- Sales Summary -->
    <div class="section">
        <div class="section-header">RÉSUMÉ DES VENTES</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Chiffre d'affaires total</th>
                        <td class="text-right">{{ number_format($salesSummary['total_revenue'], 0, ',', ' ') }} FC</td>
                    </tr>
                    <tr>
                        <th>Nombre total de ventes</th>
                        <td class="text-right">{{ number_format($salesSummary['total_sales']) }}</td>
                    </tr>
                    <tr>
                        <th>Vente moyenne</th>
                        <td class="text-right">{{ number_format($salesSummary['average_sale'], 0, ',', ' ') }} FC</td>
                    </tr>
                    <tr>
                        <th>Croissance des revenus</th>
                        <td class="text-right">
                            <span class="badge {{ $salesSummary['revenue_growth'] >= 0 ? 'badge-success' : 'badge-danger' }}">
                                {{ $salesSummary['revenue_growth'] >= 0 ? '+' : '' }}{{ $salesSummary['revenue_growth'] }}%
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Croissance des ventes</th>
                        <td class="text-right">
                            <span class="badge {{ $salesSummary['sales_growth'] >= 0 ? 'badge-success' : 'badge-danger' }}">
                                {{ $salesSummary['sales_growth'] >= 0 ? '+' : '' }}{{ $salesSummary['sales_growth'] }}%
                            </span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Top Products -->
    <div class="section">
        <div class="section-header">TOP 10 PRODUITS</div>
        <div class="section-content">
            <table>
                <thead>
                    <tr>
                        <th>Produit</th>
                        <th>Catégorie</th>
                        <th class="text-right">Quantité</th>
                        <th class="text-right">Revenus (FC)</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($topProducts as $product)
                        <tr>
                            <td>{{ $product['product']->name }}</td>
                            <td>{{ $product['product']->category->name ?? 'N/A' }}</td>
                            <td class="text-right">{{ number_format($product['total_quantity']) }}</td>
                            <td class="text-right">{{ number_format($product['total_revenue'], 0, ',', ' ') }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">Aucun produit trouvé</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Sales by User -->
    <div class="section">
        <div class="section-header">PERFORMANCE PAR UTILISATEUR</div>
        <div class="section-content">
            <table>
                <thead>
                    <tr>
                        <th>Utilisateur</th>
                        <th>Rôle</th>
                        <th class="text-right">Ventes</th>
                        <th class="text-right">Revenus (FC)</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($salesByUser as $user)
                        <tr>
                            <td>{{ $user['user']->firstname }} {{ $user['user']->lastname }}</td>
                            <td>{{ ucfirst($user['user']->role) }}</td>
                            <td class="text-right">{{ number_format($user['sales_count']) }}</td>
                            <td class="text-right">{{ number_format($user['total_revenue'], 0, ',', ' ') }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">Aucune vente trouvée</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Revenue by Payment Method -->
    <div class="section">
        <div class="section-header">REVENUS PAR MÉTHODE DE PAIEMENT</div>
        <div class="section-content">
            <table>
                <thead>
                    <tr>
                        <th>Méthode de paiement</th>
                        <th class="text-right">Revenus (FC)</th>
                        <th class="text-right">Pourcentage</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($revenueByPaymentMethod as $method)
                        <tr>
                            <td>{{ $method['method'] }}</td>
                            <td class="text-right">{{ number_format($method['amount'], 0, ',', ' ') }}</td>
                            <td class="text-right">{{ number_format($method['percentage'], 1) }}%</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="text-center">Aucune donnée disponible</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Sales by Type -->
    <div class="section">
        <div class="section-header">VENTES PAR TYPE</div>
        <div class="section-content">
            <table>
                <thead>
                    <tr>
                        <th>Type de vente</th>
                        <th class="text-right">Nombre</th>
                        <th class="text-right">Revenus (FC)</th>
                        <th class="text-right">Pourcentage</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($salesByType as $type)
                        <tr>
                            <td>{{ $type['type'] }}</td>
                            <td class="text-right">{{ number_format($type['count']) }}</td>
                            <td class="text-right">{{ number_format($type['amount'], 0, ',', ' ') }}</td>
                            <td class="text-right">{{ number_format($type['percentage'], 1) }}%</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">Aucune donnée disponible</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Customer Metrics -->
    <div class="section">
        <div class="section-header">MÉTRIQUES CLIENTS</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Clients actifs</th>
                        <td class="text-right">{{ number_format($customerMetrics['active_customers']) }}</td>
                    </tr>
                    <tr>
                        <th>Nouveaux clients</th>
                        <td class="text-right">{{ number_format($customerMetrics['new_customers']) }}</td>
                    </tr>
                    <tr>
                        <th>Clients récurrents</th>
                        <td class="text-right">{{ number_format($customerMetrics['repeat_customers']) }}</td>
                    </tr>
                    <tr>
                        <th>Taux de rétention</th>
                        <td class="text-right">{{ number_format($customerMetrics['customer_retention_rate'], 1) }}%</td>
                    </tr>
                    <tr>
                        <th>Valeur moyenne de commande</th>
                        <td class="text-right">{{ number_format($customerMetrics['average_order_value'], 0, ',', ' ') }} FC</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Rapport généré automatiquement par le système de gestion</p>
        <p>{{ config('app.name') }} - {{ now()->year }}</p>
    </div>

    <script>
        // Auto-print on page load (optional, comment out if you don't want auto-print)
        window.onload = function() {
            // Small delay to ensure page is fully rendered
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>

