<div>
    <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Rapports' => route('reports.business-intelligence'),
            'Performance des Ventes' => route('reports.sales-performance'),
            'Guide d\'interprétation' => null,
        ]" />

    <div class="mt-6 space-y-6">
        <!-- Introduction -->
        <x-basics.card title="📈 Guide d'Interprétation - Performance des Ventes"
            subtitle="Comprendre et utiliser efficacement votre rapport de performance des ventes">
            <div class="prose max-w-none">
                <p class="text-gray-700">
                    Le rapport de Performance des Ventes vous donne une analyse détaillée de vos ventes. 
                    Ce guide vous aidera à interpréter les différentes métriques et à identifier les 
                    opportunités d'amélioration.
                </p>
            </div>
        </x-basics.card>

        <!-- Financial Overview -->
        <x-basics.card title="💰 Aperçu Financier" subtitle="Comprendre les métriques financières principales">
            <div class="space-y-4">
                <div class="border-l-4 border-blue-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Revenus Totaux</h4>
                    <p class="text-sm text-gray-700">
                        La somme de tous les montants des ventes dans la période sélectionnée. 
                        C'est votre chiffre d'affaires brut pour cette période.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ montants des ventes dans la période</p>
                    </div>
                </div>

                <div class="border-l-4 border-green-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Nombre de Ventes</h4>
                    <p class="text-sm text-gray-700">
                        Le nombre total de transactions complétées dans la période. 
                        Indique le volume d'activité et la fréquence des achats.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ transactions complétées</p>
                    </div>
                </div>

                <div class="border-l-4 border-purple-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Vente Moyenne</h4>
                    <p class="text-sm text-gray-700">
                        Le montant moyen par transaction. Aide à comprendre la valeur 
                        de chaque client et l'efficacité de vos ventes.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> revenus_totaux ÷ nombre_de_ventes</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Sales Trends -->
        <x-basics.card title="📊 Tendances des Ventes" subtitle="Comprendre l'évolution de vos ventes">
            <div class="space-y-4">
                <div class="border-l-4 border-orange-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Courbe des Ventes</h4>
                    <p class="text-sm text-gray-700">
                        Graphique montrant l'évolution des revenus par date. 
                        Permet d'identifier les périodes de forte et faible activité.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Utilisation :</strong> Revenus par date pour visualiser les tendances</p>
                    </div>
                </div>

                <div class="border-l-4 border-red-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Croissance</h4>
                    <p class="text-sm text-gray-700">
                        La variation en pourcentage par rapport à la période précédente. 
                        Indique si votre activité est en croissance ou en déclin.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Calcul :</strong> variation par rapport à la période précédente</p>
                        <p><strong>Positif :</strong> Croissance | <strong>Négatif :</strong> Déclin</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Salesperson Performance -->
        <x-basics.card title="👥 Performance des Vendeurs" subtitle="Analyser la performance de votre équipe">
            <div class="space-y-4">
                <div class="border-l-4 border-indigo-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Chiffre d'Affaires</h4>
                    <p class="text-sm text-gray-700">
                        Le montant total des ventes générées par chaque vendeur. 
                        Permet d'identifier les meilleurs performeurs.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ ventes par vendeur</p>
                    </div>
                </div>

                <div class="border-l-4 border-pink-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Nombre de Ventes</h4>
                    <p class="text-sm text-gray-700">
                        Le nombre de transactions réalisées par chaque vendeur. 
                        Indique l'activité et la productivité.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ transactions par vendeur</p>
                    </div>
                </div>

                <div class="border-l-4 border-cyan-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Vente Moyenne</h4>
                    <p class="text-sm text-gray-700">
                        Le montant moyen par vente pour chaque vendeur. 
                        Aide à identifier qui génère les ventes les plus importantes.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> chiffre_d'affaires ÷ nombre_de_ventes</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Top Products -->
        <x-basics.card title="🏆 Top Produits" subtitle="Identifier vos produits les plus performants">
            <div class="space-y-4">
                <div class="border-l-4 border-yellow-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Quantité Vendue</h4>
                    <p class="text-sm text-gray-700">
                        Le nombre total d'unités vendues pour chaque produit. 
                        Identifie vos produits les plus populaires.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ quantités par produit</p>
                    </div>
                </div>

                <div class="border-l-4 border-teal-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Chiffre d'Affaires</h4>
                    <p class="text-sm text-gray-700">
                        Le montant total généré par chaque produit. 
                        Montre quels produits contribuent le plus aux revenus.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ (quantité × prix_unitaire)</p>
                    </div>
                </div>

                <div class="border-l-4 border-lime-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Prix Moyen</h4>
                    <p class="text-sm text-gray-700">
                        Le prix moyen auquel chaque produit est vendu. 
                        Aide à comprendre la stratégie de prix et la valeur perçue.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> revenus_produit ÷ quantités_vendues</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Payment Methods -->
        <x-basics.card title="💳 Revenus par Méthode de Paiement" subtitle="Analyser les préférences de paiement">
            <div class="space-y-4">
                <div class="border-l-4 border-rose-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Répartition</h4>
                    <p class="text-sm text-gray-700">
                        La part des revenus générés par chaque méthode de paiement 
                        (Espèces, Mobile Money, Carte, etc.).
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Utilisation :</strong> Comprendre les préférences de vos clients</p>
                        <p><strong>Types :</strong> Espèces, Mobile Money, Carte bancaire, etc.</p>
                    </div>
                </div>

                <div class="border-l-4 border-violet-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Pourcentage</h4>
                    <p class="text-sm text-gray-700">
                        Le pourcentage que représente chaque méthode de paiement 
                        par rapport au total des revenus.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> (revenus_méthode ÷ revenus_totaux) × 100</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Sales by Type -->
        <x-basics.card title="🏷️ Ventes par Type" subtitle="Analyser les différents types de ventes">
            <div class="space-y-4">
                <div class="border-l-4 border-sky-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Types de Ventes</h4>
                    <p class="text-sm text-gray-700">
                        Analyse des ventes par catégorie : ordonnance, OTC (sans ordonnance), 
                        gros, détail, etc.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Types courants :</strong> ordonnance, OTC, gros, détail</p>
                    </div>
                </div>

                <div class="border-l-4 border-emerald-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Montant Total</h4>
                    <p class="text-sm text-gray-700">
                        Le montant total généré par chaque type de vente. 
                        Aide à identifier les segments les plus rentables.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ revenus par type</p>
                    </div>
                </div>

                <div class="border-l-4 border-amber-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Valeur Moyenne</h4>
                    <p class="text-sm text-gray-700">
                        La valeur moyenne d'une vente pour chaque type. 
                        Aide à comprendre la taille moyenne des transactions par segment.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> revenus_type ÷ nombre_de_ventes_type</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Best Practices -->
        <x-basics.card title="✨ Bonnes Pratiques" subtitle="Optimiser votre analyse des ventes">
            <div class="space-y-3">
                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Analysez régulièrement :</strong> Consultez ce rapport quotidiennement 
                        pour identifier rapidement les tendances et anomalies.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Comparez les vendeurs :</strong> Identifiez les meilleures pratiques 
                        des vendeurs performants pour former l'équipe.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Optimisez les produits :</strong> Concentrez-vous sur les produits 
                        qui génèrent le plus de revenus et de quantité.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Adaptez les méthodes de paiement :</strong> Facilitez les méthodes 
                        de paiement les plus populaires pour améliorer l'expérience client.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Actions -->
        <x-basics.card title="⚡ Actions Recommandées" subtitle="Que faire avec ces informations?">
            <div class="space-y-4">
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <h4 class="font-semibold text-blue-900 mb-2">Pour améliorer les ventes :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-blue-800">
                        <li>Formez les vendeurs moins performants sur les techniques des meilleurs</li>
                        <li>Mettez en avant les produits les plus vendus</li>
                        <li>Offrez des incitations pour augmenter la vente moyenne</li>
                    </ul>
                </div>

                <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                    <h4 class="font-semibold text-green-900 mb-2">Pour optimiser les revenus :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-green-800">
                        <li>Concentrez-vous sur les types de ventes les plus rentables</li>
                        <li>Développez les méthodes de paiement populaires</li>
                        <li>Analysez les périodes de forte activité pour planifier le stock</li>
                    </ul>
                </div>

                <div class="bg-purple-50 border border-purple-200 rounded-lg p-4">
                    <h4 class="font-semibold text-purple-900 mb-2">Pour la croissance :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-purple-800">
                        <li>Identifiez les tendances de croissance pour les maintenir</li>
                        <li>Développez de nouveaux segments basés sur les meilleurs performeurs</li>
                        <li>Investissez dans la formation de l'équipe de vente</li>
                    </ul>
                </div>
            </div>
        </x-basics.card>
    </div>
</div>