<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rapport Intelligence Inventaire - Impression</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            background-color: #ffffff;
            padding: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #10b981;
            padding-bottom: 20px;
        }
        
        .header h1 {
            color: #059669;
            font-size: 24px;
            margin: 0 0 10px 0;
            font-weight: bold;
        }
        
        .header .period {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
            font-weight: 500;
        }
        
        .header .generated {
            color: #9ca3af;
            font-size: 11px;
        }
        
        .section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .section-header {
            background-color: #10b981;
            color: white;
            padding: 10px 15px;
            margin: 0 0 0 0;
            font-size: 14px;
            font-weight: bold;
        }
        
        .section-content {
            padding: 0;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
            background-color: white;
        }
        
        th, td {
            padding: 10px 12px;
            text-align: left;
            border: 1px solid #e2e8f0;
            font-size: 11px;
        }
        
        th {
            background-color: #10b981;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        td {
            color: #1e293b;
        }
        
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        
        tr:nth-child(odd) {
            background-color: #ffffff;
        }
        
        .metric-table {
            margin-bottom: 20px;
        }
        
        .metric-table th {
            background-color: #059669;
            width: 50%;
        }
        
        .metric-table td {
            font-weight: 600;
            color: #059669;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: 600;
        }
        
        .badge-success {
            background-color: #d1fae5;
            color: #065f46;
        }
        
        .badge-warning {
            background-color: #fef3c7;
            color: #92400e;
        }
        
        .badge-danger {
            background-color: #fee2e2;
            color: #991b1b;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e2e8f0;
            text-align: center;
            color: #6b7280;
            font-size: 10px;
        }
        
        @media print {
            body {
                padding: 10px;
            }
            
            .no-print {
                display: none !important;
            }
            
            .section {
                page-break-inside: avoid;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
        }
        
        @media screen {
            .print-button {
                position: fixed;
                top: 20px;
                right: 20px;
                padding: 12px 24px;
                background-color: #10b981;
                color: white;
                border: none;
                border-radius: 8px;
                font-size: 14px;
                font-weight: 600;
                cursor: pointer;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                z-index: 1000;
            }
            
            .print-button:hover {
                background-color: #059669;
            }
        }
    </style>
</head>
<body>
    <!-- Print Button -->
    <button onclick="window.print()" class="print-button no-print">
        <i class="ph ph-printer"></i> Imprimer
    </button>

    <!-- Header -->
    <div class="header">
        <h1>RAPPORT D'INTELLIGENCE INVENTAIRE</h1>
        <div class="period">
            Période : {{ $dateFrom->format('d/m/Y') }} - {{ $dateTo->format('d/m/Y') }}
        </div>
        <div class="generated">
            Généré le {{ now()->format('d/m/Y à H:i') }}
        </div>
    </div>

    <!-- Inventory Overview -->
    <div class="section">
        <div class="section-header">VUE D'ENSEMBLE DE L'INVENTAIRE</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Valeur totale de l'inventaire</th>
                        <td class="text-right">{{ number_format($inventoryOverview['total_inventory_value'], 0, ',', ' ') }} FC</td>
                    </tr>
                    <tr>
                        <th>Nombre total de produits</th>
                        <td class="text-right">{{ number_format($inventoryOverview['total_products']) }}</td>
                    </tr>
                    <tr>
                        <th>État de santé du stock</th>
                        <td class="text-right">
                            <span class="badge {{ $inventoryOverview['stock_health_percentage'] >= 70 ? 'badge-success' : ($inventoryOverview['stock_health_percentage'] >= 40 ? 'badge-warning' : 'badge-danger') }}">
                                {{ $inventoryOverview['stock_health_percentage'] }}%
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Produits en stock normal</th>
                        <td class="text-right">{{ number_format($inventoryOverview['healthy_stock_products']) }}</td>
                    </tr>
                    <tr>
                        <th>Produits en stock faible</th>
                        <td class="text-right">
                            <span class="badge badge-warning">{{ number_format($inventoryOverview['low_stock_products']) }}</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Produits en rupture de stock</th>
                        <td class="text-right">
                            <span class="badge badge-danger">{{ number_format($inventoryOverview['out_of_stock_products']) }}</span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Out of Stock Products -->
    <div class="section">
        <div class="section-header">PRODUITS EN RUPTURE DE STOCK</div>
        <div class="section-content">
            <table>
                <thead>
                    <tr>
                        <th>Produit</th>
                        <th>Catégorie</th>
                        <th class="text-right">Stock</th>
                        <th class="text-right">Prix d'achat</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($outOfStock as $product)
                        <tr>
                            <td>{{ $product->name }}</td>
                            <td>{{ $product->category->name ?? 'N/A' }}</td>
                            <td class="text-right">{{ number_format($product->current_stock ?? 0) }}</td>
                            <td class="text-right">{{ number_format($product->purchase_price ?? 0, 0, ',', ' ') }} FC</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">Aucun produit en rupture</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Low Stock Products -->
    <div class="section">
        <div class="section-header">PRODUITS À STOCK FAIBLE</div>
        <div class="section-content">
            <table>
                <thead>
                    <tr>
                        <th>Produit</th>
                        <th>Catégorie</th>
                        <th class="text-right">Stock actuel</th>
                        <th class="text-right">Prix d'achat</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($lowStock as $product)
                        <tr>
                            <td>{{ $product->name }}</td>
                            <td>{{ $product->category->name ?? 'N/A' }}</td>
                            <td class="text-right">
                                <span class="badge badge-warning">{{ number_format($product->current_stock ?? 0) }}</span>
                            </td>
                            <td class="text-right">{{ number_format($product->purchase_price ?? 0, 0, ',', ' ') }} FC</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">Aucun produit à stock faible</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Expiring Soon Products -->
    <div class="section">
        <div class="section-header">PRODUITS EXPIRANT BIENTÔT</div>
        <div class="section-content">
            <table>
                <thead>
                    <tr>
                        <th>Produit</th>
                        <th>Catégorie</th>
                        <th class="text-right">Date d'expiration</th>
                        <th class="text-right">Stock</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($expiringSoon as $product)
                        <tr>
                            <td>{{ $product->name }}</td>
                            <td>{{ $product->category->name ?? 'N/A' }}</td>
                            <td class="text-right">{{ $product->expiry_date ? \Carbon\Carbon::parse($product->expiry_date)->format('d/m/Y') : 'N/A' }}</td>
                            <td class="text-right">{{ number_format($product->current_stock ?? 0) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">Aucun produit expirant prochainement</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Category Insights -->
    <div class="section">
        <div class="section-header">APERÇU PAR CATÉGORIE</div>
        <div class="section-content">
            <table>
                <thead>
                    <tr>
                        <th>Catégorie</th>
                        <th class="text-right">Nb Produits</th>
                        <th class="text-right">Valeur Inventaire</th>
                        <th class="text-right">Santé du Stock</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($categoryInsights as $insight)
                        <tr>
                            <td>{{ $insight['category']->name ?? 'Sans catégorie' }}</td>
                            <td class="text-right">{{ number_format($insight['total_products']) }}</td>
                            <td class="text-right">{{ number_format($insight['total_inventory_value'], 0, ',', ' ') }} FC</td>
                            <td class="text-right">
                                <span class="badge {{ $insight['stock_health_percentage'] >= 70 ? 'badge-success' : ($insight['stock_health_percentage'] >= 40 ? 'badge-warning' : 'badge-danger') }}">
                                    {{ $insight['stock_health_percentage'] }}%
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">Aucune donnée de catégorie disponible</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Rapport généré automatiquement par le système de gestion</p>
        <p>{{ config('app.name') }} - {{ now()->year }}</p>
    </div>

    <script>
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>
