<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rapport d'Intelligence d'Inventaire</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
            background-color: #ffffff;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #3b82f6;
            padding-bottom: 20px;
        }
        
        .header h1 {
            color: #1e40af;
            font-size: 24px;
            margin: 0 0 10px 0;
            font-weight: bold;
        }
        
        .header .period {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
            font-weight: 500;
        }
        
        .header .generated {
            color: #9ca3af;
            font-size: 11px;
        }
        
        .section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .section-header {
            background-color: #3b82f6;
            color: white;
            padding: 10px 15px;
            margin: 0 0 0 0;
            font-size: 14px;
            font-weight: bold;
        }
        
        .section-content {
            padding: 0;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
            background-color: white;
        }
        
        th, td {
            padding: 10px 12px;
            text-align: left;
            border: 1px solid #e2e8f0;
            font-size: 11px;
        }
        
        th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        td {
            color: #1e293b;
        }
        
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        
        tr:nth-child(odd) {
            background-color: #ffffff;
        }
        
        .metric-table {
            margin-bottom: 20px;
        }
        
        .metric-table th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .metric-table td {
            text-align: center;
            font-weight: bold;
        }
        
        .metric-table .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .metric-table .metric-value {
            font-size: 12px;
            font-weight: bold;
            color: #1e293b;
        }
        
        .status-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 9px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .status-positive {
            background-color: #dcfce7;
            color: #166534;
        }
        
        .status-negative {
            background-color: #fecaca;
            color: #991b1b;
        }
        
        .status-warning {
            background-color: #fef3c7;
            color: #92400e;
        }
        
        .status-neutral {
            background-color: #f3f4f6;
            color: #374151;
        }
        
        .inventory-overview {
            margin-bottom: 20px;
        }
        
        .inventory-overview th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .inventory-overview td {
            text-align: center;
            font-weight: bold;
            font-size: 12px;
        }
        
        .inventory-overview .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .inventory-overview .metric-value {
            font-size: 13px;
            font-weight: bold;
            color: #1e293b;
        }
        
        .stock-analysis {
            margin-bottom: 20px;
        }
        
        .stock-analysis th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .stock-analysis td {
            text-align: center;
        }
        
        .stock-analysis .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .product-performance {
            margin-bottom: 20px;
        }
        
        .product-performance th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .product-performance td {
            text-align: center;
        }
        
        .product-performance .product-name {
            text-align: left;
            font-weight: bold;
        }
        
        .product-performance .product-category {
            text-align: left;
            font-size: 10px;
            color: #6b7280;
        }
        
        .abc-analysis {
            margin-bottom: 20px;
        }
        
        .abc-analysis th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .abc-analysis td {
            text-align: center;
            font-weight: bold;
        }
        
        .abc-analysis .class-a {
            background-color: #fef3c7;
            color: #92400e;
        }
        
        .abc-analysis .class-b {
            background-color: #dbeafe;
            color: #1e40af;
        }
        
        .abc-analysis .class-c {
            background-color: #f3f4f6;
            color: #374151;
        }
        
        .category-insights {
            margin-bottom: 20px;
        }
        
        .category-insights th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .category-insights td {
            text-align: center;
        }
        
        .category-insights .category-name {
            text-align: left;
            font-weight: bold;
        }
        
        .strategic-insights {
            margin-top: 20px;
            padding: 15px;
            background-color: #fef2f2;
            border-left: 4px solid #dc2626;
            border-radius: 4px;
        }
        
        .strategic-insights h4 {
            color: #dc2626;
            margin: 0 0 8px 0;
            font-size: 12px;
            font-weight: bold;
        }
        
        .strategic-insights p {
            color: #7f1d1d;
            margin: 0;
            font-size: 11px;
            line-height: 1.4;
        }
        
        .insight-item {
            margin-bottom: 10px;
            padding: 8px 12px;
            border-radius: 4px;
            font-size: 11px;
        }
        
        .insight-success {
            background-color: #f0fdf4;
            border-left: 4px solid #22c55e;
        }
        
        .insight-warning {
            background-color: #fffbeb;
            border-left: 4px solid #f59e0b;
        }
        
        .insight-danger {
            background-color: #fef2f2;
            border-left: 4px solid #ef4444;
        }
        
        .insight-info {
            background-color: #eff6ff;
            border-left: 4px solid #3b82f6;
        }
        
        .empty-data {
            text-align: center;
            color: #9ca3af;
            font-style: italic;
            padding: 20px;
        }
        
        .rank-badge {
            display: inline-block;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            text-align: center;
            line-height: 20px;
            font-size: 9px;
            font-weight: bold;
            color: white;
        }
        
        .rank-1 { background-color: #fbbf24; }
        .rank-2 { background-color: #9ca3af; }
        .rank-3 { background-color: #f59e0b; }
        .rank-other { background-color: #6b7280; }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>Rapport d'Intelligence d'Inventaire</h1>
        <div class="period">Période: {{ $dateFrom->format('d/m/Y') }} - {{ $dateTo->format('d/m/Y') }}</div>
        <div class="generated">Généré le: {{ \Carbon\Carbon::now()->format('d/m/Y à H:i') }}</div>
    </div>

    <!-- Vue d'Ensemble de l'Inventaire -->
    <div class="section">
        <div class="section-header">Vue d'Ensemble de l'Inventaire</div>
        <div class="section-content">
            <table class="inventory-overview">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Valeur</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Valeur Totale de l'Inventaire</td>
                        <td class="metric-value">{{ number_format($inventoryOverview['total_inventory_value'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Nombre Total de Produits</td>
                        <td class="metric-value">{{ number_format($inventoryOverview['total_products']) }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Santé du Stock</td>
                        <td class="metric-value">{{ $inventoryOverview['stock_health_percentage'] }}%</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Produits en Stock Faible</td>
                        <td class="metric-value">{{ number_format($inventoryOverview['low_stock_products']) }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Produits en Rupture de Stock</td>
                        <td class="metric-value">{{ number_format($inventoryOverview['out_of_stock_products']) }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Produits en Surstock</td>
                        <td class="metric-value">{{ number_format($inventoryOverview['overstock_products']) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Analyse des Stocks -->
    <div class="section">
        <div class="section-header">Analyse des Stocks par Niveau</div>
        <div class="section-content">
            <table class="stock-analysis">
                <thead>
                    <tr>
                        <th>Niveau de Stock</th>
                        <th>Nombre de Produits</th>
                        <th>Pourcentage</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalProducts = $inventoryOverview['total_products'];
                    @endphp
                    <tr>
                        <td class="metric-label">Rupture de Stock</td>
                        <td>{{ $stockAnalysis['stock_distribution']['out_of_stock'] }}</td>
                        <td>{{ $totalProducts > 0 ? round(($stockAnalysis['stock_distribution']['out_of_stock'] / $totalProducts) * 100, 1) : 0 }}%</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Stock Faible</td>
                        <td>{{ $stockAnalysis['stock_distribution']['low_stock'] }}</td>
                        <td>{{ $totalProducts > 0 ? round(($stockAnalysis['stock_distribution']['low_stock'] / $totalProducts) * 100, 1) : 0 }}%</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Stock Normal</td>
                        <td>{{ $stockAnalysis['stock_distribution']['normal_stock'] }}</td>
                        <td>{{ $totalProducts > 0 ? round(($stockAnalysis['stock_distribution']['normal_stock'] / $totalProducts) * 100, 1) : 0 }}%</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Stock Élevé</td>
                        <td>{{ $stockAnalysis['stock_distribution']['high_stock'] }}</td>
                        <td>{{ $totalProducts > 0 ? round(($stockAnalysis['stock_distribution']['high_stock'] / $totalProducts) * 100, 1) : 0 }}%</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Surstock</td>
                        <td>{{ $stockAnalysis['stock_distribution']['overstock'] }}</td>
                        <td>{{ $totalProducts > 0 ? round(($stockAnalysis['stock_distribution']['overstock'] / $totalProducts) * 100, 1) : 0 }}%</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Performance des Produits -->
    <div class="section">
        <div class="section-header">Top 10 Produits les Plus Vendus</div>
        <div class="section-content">
            <table class="product-performance">
                <thead>
                    <tr>
                        <th>Rang</th>
                        <th>Produit</th>
                        <th>Quantité Vendue</th>
                        <th>Chiffre d'Affaires</th>
                        <th>Stock Actuel</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($productPerformance['top_selling_products'] as $index => $product)
                    <tr>
                        <td>
                            <span class="rank-badge @if($index === 0) rank-1 @elseif($index === 1) rank-2 @elseif($index === 2) rank-3 @else rank-other @endif">
                                {{ $index + 1 }}
                            </span>
                        </td>
                        <td>
                            <div class="product-name">{{ $product['product']->name }}</div>
                            <div class="product-category">{{ $product['product']->category->name ?? 'Sans catégorie' }}</div>
                        </td>
                        <td>{{ number_format($product['total_quantity'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($product['total_revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td>
                            @if($product['product']->current_stock == 0)
                                <span class="status-badge status-negative">0</span>
                            @elseif($product['product']->current_stock <= 10)
                                <span class="status-badge status-warning">{{ $product['product']->current_stock }}</span>
                            @else
                                <span class="status-badge status-positive">{{ $product['product']->current_stock }}</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Analyse ABC -->
    <div class="section">
        <div class="section-header">Analyse ABC des Produits</div>
        <div class="section-content">
            <table class="abc-analysis">
                <thead>
                    <tr>
                        <th>Classe</th>
                        <th>Nombre de Produits</th>
                        <th>Revenus Générés</th>
                        <th>Pourcentage des Revenus</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalRevenue = $abcAnalysis['A']['revenue'] + $abcAnalysis['B']['revenue'] + $abcAnalysis['C']['revenue'];
                    @endphp
                    <tr>
                        <td class="class-a">Classe A (80%)</td>
                        <td>{{ $abcAnalysis['A']['count'] }}</td>
                        <td>{{ number_format($abcAnalysis['A']['revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td>{{ $totalRevenue > 0 ? round(($abcAnalysis['A']['revenue'] / $totalRevenue) * 100, 1) : 0 }}%</td>
                    </tr>
                    <tr>
                        <td class="class-b">Classe B (15%)</td>
                        <td>{{ $abcAnalysis['B']['count'] }}</td>
                        <td>{{ number_format($abcAnalysis['B']['revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td>{{ $totalRevenue > 0 ? round(($abcAnalysis['B']['revenue'] / $totalRevenue) * 100, 1) : 0 }}%</td>
                    </tr>
                    <tr>
                        <td class="class-c">Classe C (5%)</td>
                        <td>{{ $abcAnalysis['C']['count'] }}</td>
                        <td>{{ number_format($abcAnalysis['C']['revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td>{{ $totalRevenue > 0 ? round(($abcAnalysis['C']['revenue'] / $totalRevenue) * 100, 1) : 0 }}%</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Insights par Catégorie -->
    <div class="section">
        <div class="section-header">Analyse par Catégorie</div>
        <div class="section-content">
            <table class="category-insights">
                <thead>
                    <tr>
                        <th>Catégorie</th>
                        <th>Nombre de Produits</th>
                        <th>Valeur du Stock</th>
                        <th>Santé du Stock</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categoryInsights as $category)
                    <tr>
                        <td class="category-name">{{ $category['category']->name }}</td>
                        <td>{{ $category['total_products'] }}</td>
                        <td>{{ number_format($category['total_inventory_value'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td>
                            @if($category['stock_health_percentage'] >= 80)
                                <span class="status-badge status-positive">{{ $category['stock_health_percentage'] }}%</span>
                            @elseif($category['stock_health_percentage'] >= 60)
                                <span class="status-badge status-warning">{{ $category['stock_health_percentage'] }}%</span>
                            @else
                                <span class="status-badge status-negative">{{ $category['stock_health_percentage'] }}%</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Insights Stratégiques -->
    <div class="section">
        <div class="section-header">Insights Stratégiques</div>
        <div class="section-content">
            @if(count($strategicInsights) > 0)
                @foreach($strategicInsights as $insight)
                <div class="insight-item @if($insight['type'] === 'success') insight-success @elseif($insight['type'] === 'warning') insight-warning @elseif($insight['type'] === 'danger') insight-danger @else insight-info @endif">
                    <strong>{{ $insight['title'] }}</strong><br>
                    {{ $insight['message'] }}
                </div>
                @endforeach
            @else
                <div class="empty-data">Aucun insight stratégique disponible pour cette période.</div>
            @endif
        </div>
    </div>

</body>
</html>