<div>
    <div class="container mx-auto" x-data="businessIntelligenceDashboard()" x-init="init()">
        <!-- Header -->
        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Rapports' => route('reports.business-intelligence'),
            'Vue d\'Ensemble BI du ' . ($dateFrom ? \Carbon\Carbon::parse($dateFrom)->format('d/m/Y') : ' - ') . ' au ' . ($dateTo ? \Carbon\Carbon::parse($dateTo)->format('d/m/Y') : ' - ') => null,
        ]">
            <x-slot name="action">
                <x-dashboard.reports.business-dropdown :dateFrom="$dateFrom" :dateTo="$dateTo" />
            </x-slot>
        </x-dashboard.breadcrumb>

        <!-- Executive Summary Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mt-6 mb-8">
            <!-- Total Revenue -->
            <div class="bg-gradient-to-br from-green-50 to-green-100 border border-green-200 rounded-xl p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-green-600 text-sm font-medium">Revenus Totaux</p>
                        <p class="text-xl font-bold text-green-800">
                            {{ number_format($financialOverview['total_revenue'], 0, ',', ' ') }}
                            {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                        </p>
                        <p class="text-sm text-gray-600">
                            @if($financialOverview['revenue_growth'] >= 0)
                                <span class="text-green-600">↗ +{{ $financialOverview['revenue_growth'] }}%</span>
                            @else
                                <span class="text-red-600">↘ {{ $financialOverview['revenue_growth'] }}%</span>
                            @endif
                            vs période précédente
                        </p>
                    </div>
                    <div class="w-12 h-12 bg-green-500 rounded-lg flex items-center justify-center">
                        <i class="ph ph-currency-dollar text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Net Profit -->
            <div class="bg-gradient-to-br from-blue-50 to-blue-100 border border-blue-200 rounded-xl p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-blue-600 text-sm font-medium">Bénéfice Net</p>
                        <p class="text-xl font-bold text-blue-800">
                            {{ number_format($financialOverview['net_profit'], 0, ',', ' ') }}
                            {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                        </p>
                        <p class="text-sm text-gray-600">
                            Marge: {{ $financialOverview['net_profit_margin'] }}%
                        </p>
                    </div>
                    <div class="w-12 h-12 bg-blue-500 rounded-lg flex items-center justify-center">
                        <i class="ph ph-trend-up text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Active Customers -->
            <div class="bg-gradient-to-br from-purple-50 to-purple-100 border border-purple-200 rounded-xl p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-purple-600 text-sm font-medium">Clients Actifs</p>
                        <p class="text-xl font-bold text-purple-800">
                            {{ number_format($customerInsights['active_customers'], 0, ',', ' ') }}
                        </p>
                        <p class="text-sm text-gray-600">
                            {{ $customerInsights['new_customers'] }} nouveaux clients
                        </p>
                    </div>
                    <div class="w-12 h-12 bg-purple-500 rounded-lg flex items-center justify-center">
                        <i class="ph ph-users text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Inventory Value -->
            <div class="bg-gradient-to-br from-orange-50 to-orange-100 border border-orange-200 rounded-xl p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-orange-600 text-sm font-medium">Valeur Inventaire</p>
                        <p class="text-xl font-bold text-orange-800">
                            {{ number_format($inventoryInsights['total_inventory_value'], 0, ',', ' ') }}
                            {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                        </p>
                        <p class="text-sm text-gray-600">
                            {{ $inventoryInsights['total_products'] }} produits
                        </p>
                    </div>
                    <div class="w-12 h-12 bg-orange-500 rounded-lg flex items-center justify-center">
                        <i class="ph ph-package text-white text-xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Financial Performance Overview -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-chart-line text-green-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Performance Financière</h3>
                        <p class="text-sm text-gray-600">Vue d'ensemble des métriques financières clés</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="p-4 bg-green-50 rounded-lg border border-green-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-green-600 text-sm font-medium">Bénéfice Brut</p>
                            <p class="text-xl font-bold text-green-800">
                                {{ number_format($financialOverview['gross_profit'], 0, ',', ' ') }}
                                {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                            </p>
                            <p class="text-sm text-gray-600">Marge: {{ $financialOverview['gross_profit_margin'] }}%</p>
                        </div>
                        <i class="ph ph-trend-up text-green-500 text-2xl"></i>
                    </div>
                </div>

                <div class="p-4 bg-red-50 rounded-lg border border-red-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-red-600 text-sm font-medium">Dépenses</p>
                            <p class="text-xl font-bold text-red-800">
                                {{ number_format($financialOverview['total_expenses'], 0, ',', ' ') }}
                                {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                            </p>
                        </div>
                        <i class="ph ph-trend-down text-red-500 text-2xl"></i>
                    </div>
                </div>

                <div class="p-4 bg-blue-50 rounded-lg border border-blue-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-blue-600 text-sm font-medium">Coût des Ventes</p>
                            <p class="text-xl font-bold text-blue-800">
                                {{ number_format($financialOverview['cost_of_goods_sold'], 0, ',', ' ') }}
                                {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                            </p>
                        </div>
                        <i class="ph ph-shopping-cart text-blue-500 text-2xl"></i>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Sales Performance -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-chart-bar text-blue-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Performance des Ventes</h3>
                        <p class="text-sm text-gray-600">Métriques de vente et produits performants</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Sales Metrics -->
                <div class="space-y-4">
                    <div class="p-4 bg-blue-50 rounded-lg border border-blue-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-blue-600 text-sm font-medium">Total Ventes</p>
                                <p class="text-2xl font-bold text-blue-800">{{ $salesPerformance['total_sales'] }}</p>
                            </div>
                            <i class="ph ph-shopping-bag text-blue-500 text-2xl"></i>
                        </div>
                    </div>
                    <div class="p-4 bg-green-50 rounded-lg border border-green-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-green-600 text-sm font-medium">Valeur Moyenne Commande</p>
                                <p class="text-2xl font-bold text-green-800">
                                    {{ number_format($salesPerformance['average_order_value'], 0, ',', ' ') }}
                                    {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </p>
                            </div>
                            <i class="ph ph-currency-dollar text-green-500 text-2xl"></i>
                        </div>
                    </div>
                </div>

                <!-- Top Products -->
                <div>
                    <h4 class="font-semibold text-gray-900 mb-4">Top 5 Produits</h4>
                    <div class="space-y-3">
                        @foreach($salesPerformance['top_products'] as $product)
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-indigo-100 rounded-lg flex items-center justify-center">
                                    <i class="ph ph-package text-indigo-600 text-sm"></i>
                                </div>
                                <div>
                                    <span class="font-medium text-gray-900">{{ $product->name }}</span>
                                    <p class="text-sm text-gray-600">{{ $product->total_quantity ?? 0 }} vendus</p>
                                </div>
                            </div>
                            <span class="text-sm font-medium text-gray-900">
                                {{ number_format($product->total_revenue ?? 0, 0, ',', ' ') }} FCFA
                            </span>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Customer Insights -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-users text-purple-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Insights Clients</h3>
                        <p class="text-sm text-gray-600">Analyse de la base client et engagement</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div class="text-center p-4 bg-purple-50 rounded-lg border border-purple-200">
                    <div class="text-2xl font-bold text-purple-800">{{ $customerInsights['total_customers'] }}</div>
                    <div class="text-sm text-purple-600">Total Clients</div>
                </div>
                <div class="text-center p-4 bg-green-50 rounded-lg border border-green-200">
                    <div class="text-2xl font-bold text-green-800">{{ $customerInsights['active_customers'] }}</div>
                    <div class="text-sm text-green-600">Clients Actifs</div>
                </div>
                <div class="text-center p-4 bg-blue-50 rounded-lg border border-blue-200">
                    <div class="text-2xl font-bold text-blue-800">{{ $customerInsights['new_customers'] }}</div>
                    <div class="text-sm text-blue-600">Nouveaux Clients</div>
                </div>
                <div class="text-center p-4 bg-orange-50 rounded-lg border border-orange-200">
                    <div class="text-2xl font-bold text-orange-800">
                        {{ number_format($customerInsights['customer_lifetime_value'], 0, ',', ' ') }}
                    </div>
                    <div class="text-sm text-orange-600">Valeur Vie Client (FCFA)</div>
                </div>
            </div>
        </x-basics.card>

        <!-- Inventory & Operations -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-package text-orange-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Inventaire & Opérations</h3>
                        <p class="text-sm text-gray-600">Gestion des stocks et opérations</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Inventory Status -->
                <div>
                    <h4 class="font-semibold text-gray-900 mb-4">État des Stocks</h4>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-green-50 rounded-lg border border-green-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-check-circle text-green-600"></i>
                                <span class="text-gray-900">Stock Normal</span>
                            </div>
                            <span class="font-medium text-green-800">
                                {{ $inventoryInsights['total_products'] - $inventoryInsights['low_stock_products'] - $inventoryInsights['out_of_stock_products'] }}
                            </span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-yellow-50 rounded-lg border border-yellow-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-warning text-yellow-600"></i>
                                <span class="text-gray-900">Stock Faible</span>
                            </div>
                            <span class="font-medium text-yellow-800">{{ $inventoryInsights['low_stock_products'] }}</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-red-50 rounded-lg border border-red-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-x-circle text-red-600"></i>
                                <span class="text-gray-900">Rupture de Stock</span>
                            </div>
                            <span class="font-medium text-red-800">{{ $inventoryInsights['out_of_stock_products'] }}</span>
                        </div>
                    </div>
                </div>

                <!-- Operational Metrics -->
                <div>
                    <h4 class="font-semibold text-gray-900 mb-4">Métriques Opérationnelles</h4>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-blue-50 rounded-lg border border-blue-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-truck text-blue-600"></i>
                                <span class="text-gray-900">Fournisseurs Actifs</span>
                            </div>
                            <span class="font-medium text-blue-800">{{ $operationalMetrics['active_suppliers'] }}</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-green-50 rounded-lg border border-green-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-check-circle text-green-600"></i>
                                <span class="text-gray-900">Commandes Complétées</span>
                            </div>
                            <span class="font-medium text-green-800">{{ $operationalMetrics['completed_purchase_orders'] }}</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-orange-50 rounded-lg border border-orange-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-currency-dollar text-orange-600"></i>
                                <span class="text-gray-900">Dettes en Attente</span>
                            </div>
                            <span class="font-medium text-orange-800">
                                {{ number_format($operationalMetrics['pending_debts'], 0, ',', ' ') }} FCFA
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Risk Assessment -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-shield-warning text-red-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Évaluation des Risques</h3>
                        <p class="text-sm text-gray-600">Identification des risques et alertes</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="p-4 bg-red-50 rounded-lg border border-red-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-red-600 text-sm font-medium">Ratio Dette/Revenus</p>
                            <p class="text-2xl font-bold text-red-800">{{ $riskAssessment['debt_to_revenue_ratio'] }}%</p>
                            <p class="text-sm text-gray-600">Risque financier</p>
                        </div>
                        <i class="ph ph-warning text-red-500 text-2xl"></i>
                    </div>
                </div>
                <div class="p-4 bg-yellow-50 rounded-lg border border-yellow-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-yellow-600 text-sm font-medium">Risque Stock</p>
                            <p class="text-2xl font-bold text-yellow-800">{{ $riskAssessment['inventory_risk'] }}</p>
                            <p class="text-sm text-gray-600">Produits en rupture</p>
                        </div>
                        <i class="ph ph-package text-yellow-500 text-2xl"></i>
                    </div>
                </div>
                <div class="p-4 bg-orange-50 rounded-lg border border-orange-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-orange-600 text-sm font-medium">Stock Faible</p>
                            <p class="text-2xl font-bold text-orange-800">{{ $riskAssessment['low_stock_risk'] }}</p>
                            <p class="text-sm text-gray-600">Produits à réapprovisionner</p>
                        </div>
                        <i class="ph ph-warning-circle text-orange-500 text-2xl"></i>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Customer Segmentation & Loyalty -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-users text-purple-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Analyse Client & Fidélité</h3>
                        <p class="text-sm text-gray-600">Segmentation et analyse de la fidélité client</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Customer Metrics -->
                <div>
                    <h4 class="font-semibold text-gray-900 mb-4">Métriques Client</h4>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-blue-50 rounded-lg border border-blue-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-users text-blue-600"></i>
                                <span class="text-gray-900">Total Clients</span>
                            </div>
                            <span class="font-medium text-blue-800">{{ $customerInsights['total_customers'] }}</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-green-50 rounded-lg border border-green-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-user-plus text-green-600"></i>
                                <span class="text-gray-900">Nouveaux Clients</span>
                            </div>
                            <span class="font-medium text-green-800">{{ $customerInsights['new_customers'] }}</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-purple-50 rounded-lg border border-purple-200">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-currency-dollar text-purple-600"></i>
                                <span class="text-gray-900">Valeur Vie Client</span>
                            </div>
                            <span class="font-medium text-purple-800">
                                {{ number_format($customerInsights['customer_lifetime_value'], 0, ',', ' ') }} FCFA
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Customer Health -->
                <div>
                    <h4 class="font-semibold text-gray-900 mb-4">Santé de la Base Client</h4>
                    <div class="space-y-3">
                        <div class="p-3 bg-green-50 rounded-lg border border-green-200">
                            <div class="flex items-center justify-between">
                                <span class="text-green-800 font-medium">Clients Actifs</span>
                                <span class="text-green-600">{{ $customerInsights['active_customers'] }}</span>
                            </div>
                            <div class="w-full bg-green-200 rounded-full h-2 mt-2">
                                <div class="bg-green-600 h-2 rounded-full" style="width: {{ $customerInsights['total_customers'] > 0 ? ($customerInsights['active_customers'] / $customerInsights['total_customers']) * 100 : 0 }}%"></div>
                            </div>
                        </div>
                        <div class="p-3 bg-blue-50 rounded-lg border border-blue-200">
                            <div class="flex items-center justify-between">
                                <span class="text-blue-800 font-medium">Taux d'Activité</span>
                                <span class="text-blue-600">
                                    {{ $customerInsights['total_customers'] > 0 ? round(($customerInsights['active_customers'] / $customerInsights['total_customers']) * 100, 1) : 0 }}%
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Financial Health Analysis -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-shield-check text-green-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Santé Financière</h3>
                        <p class="text-sm text-gray-600">Analyse de la santé financière et des ratios clés</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="p-4 bg-green-50 rounded-lg border border-green-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-green-600 text-sm font-medium">Marge Brute</p>
                            <p class="text-2xl font-bold text-green-800">{{ $financialOverview['gross_profit_margin'] }}%</p>
                            <p class="text-sm text-gray-600">Performance des ventes</p>
                        </div>
                        <i class="ph ph-trend-up text-green-500 text-2xl"></i>
                    </div>
                </div>
                <div class="p-4 bg-blue-50 rounded-lg border border-blue-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-blue-600 text-sm font-medium">Marge Nette</p>
                            <p class="text-2xl font-bold text-blue-800">{{ $financialOverview['net_profit_margin'] }}%</p>
                            <p class="text-sm text-gray-600">Rentabilité globale</p>
                        </div>
                        <i class="ph ph-chart-line text-blue-500 text-2xl"></i>
                    </div>
                </div>
                <div class="p-4 bg-purple-50 rounded-lg border border-purple-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-purple-600 text-sm font-medium">Croissance</p>
                            <p class="text-2xl font-bold text-purple-800">
                                @if($financialOverview['revenue_growth'] >= 0)
                                    +{{ $financialOverview['revenue_growth'] }}%
                                @else
                                    {{ $financialOverview['revenue_growth'] }}%
                                @endif
                            </p>
                            <p class="text-sm text-gray-600">vs période précédente</p>
                        </div>
                        <i class="ph ph-arrow-up text-purple-500 text-2xl"></i>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Strategic Insights -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-indigo-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-lightbulb text-indigo-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Insights Stratégiques</h3>
                        <p class="text-sm text-gray-600">Recommandations et alertes importantes</p>
                    </div>
                </div>
            </div>

            <div class="space-y-4">
                @foreach($strategicInsights as $insight)
                <div class="p-4 rounded-lg border @if($insight['type'] === 'success') bg-green-50 border-green-200 @elseif($insight['type'] === 'warning') bg-yellow-50 border-yellow-200 @elseif($insight['type'] === 'danger') bg-red-50 border-red-200 @else bg-blue-50 border-blue-200 @endif">
                    <div class="flex items-start gap-3">
                        <div class="w-8 h-8 rounded-lg flex items-center justify-center @if($insight['type'] === 'success') bg-green-100 @elseif($insight['type'] === 'warning') bg-yellow-100 @elseif($insight['type'] === 'danger') bg-red-100 @else bg-blue-100 @endif">
                            @if($insight['type'] === 'success')
                                <i class="ph ph-check-circle text-green-600"></i>
                            @elseif($insight['type'] === 'warning')
                                <i class="ph ph-warning text-yellow-600"></i>
                            @elseif($insight['type'] === 'danger')
                                <i class="ph ph-x-circle text-red-600"></i>
                            @else
                                <i class="ph ph-info text-blue-600"></i>
                            @endif
                        </div>
                        <div>
                            <h4 class="font-semibold text-gray-900">{{ $insight['title'] }}</h4>
                            <p class="text-sm text-gray-600 mt-1">{{ $insight['message'] }}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </x-basics.card>
    </div>


@push('scripts')
    <script>
        function businessIntelligenceDashboard() {
            return {
                showExportModal: false,

                init() {
                    // Initialize any charts or interactive elements here
                    this.$nextTick(() => {
                        // Chart initialization can be added here if needed
                    });
                }
            }
        }

        // Make the function globally available
        window.businessIntelligenceDashboard = businessIntelligenceDashboard;
    </script>
@endpush
