<div>
    <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Rapports' => route('reports.business-intelligence'),
            'Business Intelligence' => route('reports.business-intelligence'),
            'Guide d\'interprétation' => null,
        ]" />

    <div class="mt-6 space-y-6">
        <!-- Introduction -->
        <x-basics.card title="📊 Guide d'Interprétation - Business Intelligence"
            subtitle="Comprendre et utiliser efficacement votre tableau de bord BI">
            <div class="prose max-w-none">
                <p class="text-gray-700">
                    Le tableau de bord Business Intelligence vous donne une vue d'ensemble de votre activité. 
                    Ce guide vous aidera à interpréter les différentes métriques et formules utilisées pour 
                    prendre des décisions éclairées.
                </p>
            </div>
        </x-basics.card>

        <!-- Key Metrics -->
        <x-basics.card title="💰 Ventes & Revenus" subtitle="Comprendre les métriques financières">
            <div class="space-y-4">
                <div class="border-l-4 border-blue-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Revenus Totaux</h4>
                    <p class="text-sm text-gray-700">
                        La somme de tous les montants des ventes dans la période sélectionnée. 
                        C'est votre chiffre d'affaires brut.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ montants des ventes</p>
                    </div>
                </div>

                <div class="border-l-4 border-green-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Nombre de Ventes</h4>
                    <p class="text-sm text-gray-700">
                        Le nombre total de transactions complétées. Indique le volume d'activité.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ transactions complétées</p>
                    </div>
                </div>

                <div class="border-l-4 border-purple-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Vente Moyenne</h4>
                    <p class="text-sm text-gray-700">
                        Le montant moyen par transaction. Aide à comprendre la valeur de chaque client.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> revenus_totaux ÷ nombre_de_ventes</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Stock Metrics -->
        <x-basics.card title="📦 Stock & Inventaire" subtitle="Comprendre les métriques d'inventaire">
            <div class="space-y-4">
                <div class="border-l-4 border-orange-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Valeur Inventaire</h4>
                    <p class="text-sm text-gray-700">
                        La valeur totale de votre stock basée sur les prix d'achat. 
                        Représente le capital immobilisé dans votre inventaire.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ (stock_actuel × prix_d'achat)</p>
                    </div>
                </div>

                <div class="border-l-4 border-red-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Santé du Stock</h4>
                    <p class="text-sm text-gray-700">
                        Le pourcentage de produits avec un stock sain (ni faible ni en rupture).
                        Un pourcentage élevé indique une bonne gestion de stock.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> (produits_sains ÷ produits_totaux) × 100</p>
                        <p><strong>Produits sains :</strong> max(0, total − faibles − ruptures)</p>
                        <p><strong>Borne :</strong> le pourcentage est limité entre 0 et 100</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Customer Metrics -->
        <x-basics.card title="👥 Clients & Comportements" subtitle="Comprendre les métriques clients">
            <div class="space-y-4">
                <div class="border-l-4 border-indigo-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Clients Actifs</h4>
                    <p class="text-sm text-gray-700">
                        Nombre de clients ayant effectué au moins un achat dans la période.
                        Indique l'engagement de votre clientèle.
                    </p>
                </div>

                <div class="border-l-4 border-pink-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Récurrence</h4>
                    <p class="text-sm text-gray-700">
                        Nombre de clients ayant effectué plus d'un achat. 
                        Indique la fidélité de vos clients.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Rotation & Costs -->
        <x-basics.card title="🔄 Rotation & Coûts" subtitle="Comprendre les métriques de rotation">
            <div class="space-y-4">
                <div class="border-l-4 border-yellow-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">COGS (Coût des Ventes)</h4>
                    <p class="text-sm text-gray-700">
                        Le coût total des marchandises vendues. Représente ce que vous avez dépensé 
                        pour les produits que vous avez vendus.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ (quantité × coût_vente)</p>
                    </div>
                </div>

                <div class="border-l-4 border-teal-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Rotation des Stocks</h4>
                    <p class="text-sm text-gray-700">
                        Indique combien de fois votre inventaire se renouvelle par an. 
                        Une rotation élevée est généralement positive.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> COGS ÷ valeur_moyenne_inventaire</p>
                        <p><strong>Valeur moyenne inventaire :</strong> moyenne de (stock × prix d'achat)</p>
                    </div>
                </div>

                <div class="border-l-4 border-cyan-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Jours en Stock</h4>
                    <p class="text-sm text-gray-700">
                        Nombre moyen de jours qu'un produit reste en stock avant d'être vendu.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Si rotation > 0, 365 ÷ rotation; sinon 999</p>
                        <p><strong>Interprétation :</strong> Moins de jours = meilleure rotation</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Best Practices -->
        <x-basics.card title="✨ Bonnes Pratiques" subtitle="Optimiser votre analyse BI">
            <div class="space-y-3">
                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Consultez régulièrement :</strong> Vérifiez ces métriques quotidiennement 
                        pour identifier rapidement les tendances et problèmes.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Comparez les périodes :</strong> Analysez les variations par rapport 
                        aux périodes précédentes pour identifier les tendances.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Surveillez la santé du stock :</strong> Un pourcentage élevé indique 
                        une bonne gestion, un pourcentage faible nécessite une attention.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Optimisez la rotation :</strong> Une rotation élevée avec des jours 
                        en stock faibles indique une gestion efficace de l'inventaire.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Actions -->
        <x-basics.card title="⚡ Actions Recommandées" subtitle="Que faire avec ces informations?">
            <div class="space-y-4">
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <h4 class="font-semibold text-blue-900 mb-2">Si la santé du stock est faible :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-blue-800">
                        <li>Réapprovisionnez les produits en rupture immédiatement</li>
                        <li>Planifiez des commandes pour les stocks faibles</li>
                        <li>Réévaluez vos niveaux de réapprovisionnement</li>
                    </ul>
                </div>

                <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                    <h4 class="font-semibold text-green-900 mb-2">Si la rotation est faible :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-green-800">
                        <li>Envisagez des promotions pour les produits à rotation lente</li>
                        <li>Réévaluez vos prix de vente</li>
                        <li>Analysez la demande réelle de ces produits</li>
                    </ul>
                </div>

                <div class="bg-purple-50 border border-purple-200 rounded-lg p-4">
                    <h4 class="font-semibold text-purple-900 mb-2">Pour optimiser les revenus :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-purple-800">
                        <li>Concentrez-vous sur l'augmentation du nombre de ventes</li>
                        <li>Améliorez la vente moyenne par transaction</li>
                        <li>Développez la fidélité client (récurrence)</li>
                    </ul>
                </div>
            </div>
        </x-basics.card>
    </div>
</div>