<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rapport Business Intelligence</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
            background-color: #ffffff;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #3b82f6;
            padding-bottom: 20px;
        }
        
        .header h1 {
            color: #1e40af;
            font-size: 24px;
            margin: 0 0 10px 0;
            font-weight: bold;
        }
        
        .header .period {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
            font-weight: 500;
        }
        
        .header .generated {
            color: #9ca3af;
            font-size: 11px;
        }
        
        .section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .section-header {
            background-color: #3b82f6;
            color: white;
            padding: 10px 15px;
            margin: 0 0 0 0;
            font-size: 14px;
            font-weight: bold;
        }
        
        .section-content {
            padding: 0;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
            background-color: white;
        }
        
        th, td {
            padding: 10px 12px;
            text-align: left;
            border: 1px solid #e2e8f0;
            font-size: 11px;
        }
        
        th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        td {
            color: #1e293b;
        }
        
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        
        tr:nth-child(odd) {
            background-color: #ffffff;
        }
        
        .metric-table {
            margin-bottom: 20px;
        }
        
        .metric-table th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .metric-table td {
            text-align: center;
            font-weight: bold;
        }
        
        .metric-table .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .metric-table .metric-value {
            font-size: 12px;
            font-weight: bold;
            color: #1e293b;
        }
        
        .status-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 9px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .status-positive {
            background-color: #dcfce7;
            color: #166534;
        }
        
        .status-negative {
            background-color: #fecaca;
            color: #991b1b;
        }
        
        .status-neutral {
            background-color: #f3f4f6;
            color: #374151;
        }
        
        .status-good {
            background-color: #dcfce7;
            color: #166534;
        }
        
        .status-weak {
            background-color: #fecaca;
            color: #991b1b;
        }
        
        .financial-overview {
            margin-bottom: 20px;
        }
        
        .financial-overview th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .financial-overview td {
            text-align: center;
            font-weight: bold;
            font-size: 12px;
        }
        
        .financial-overview .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .financial-overview .metric-value {
            font-size: 13px;
            font-weight: bold;
            color: #1e293b;
        }
        
        .trend-analysis {
            margin-bottom: 20px;
        }
        
        .trend-analysis th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .trend-analysis td {
            text-align: center;
        }
        
        .trend-analysis .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .trend-analysis .growth-positive {
            color: #059669;
            font-weight: bold;
        }
        
        .trend-analysis .growth-negative {
            color: #dc2626;
            font-weight: bold;
        }
        
        .trend-analysis .growth-neutral {
            color: #6b7280;
            font-weight: bold;
        }
        
        .recommendations {
            margin-top: 20px;
            padding: 15px;
            background-color: #fef2f2;
            border-left: 4px solid #dc2626;
            border-radius: 4px;
        }
        
        .recommendations h4 {
            color: #dc2626;
            margin: 0 0 8px 0;
            font-size: 12px;
            font-weight: bold;
        }
        
        .recommendations p {
            color: #7f1d1d;
            margin: 0;
            font-size: 11px;
            line-height: 1.4;
        }
        
        .empty-data {
            text-align: center;
            color: #9ca3af;
            font-style: italic;
            padding: 20px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>Rapport Business Intelligence</h1>
        <div class="period">Période: {{ \Carbon\Carbon::parse($startDate)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($endDate)->format('d/m/Y') }}</div>
        <div class="generated">Généré le: {{ \Carbon\Carbon::now()->format('d/m/Y à H:i') }}</div>
    </div>

    <!-- Aperçu Financier -->
    <div class="section">
        <div class="section-header">Aperçu Financier</div>
        <div class="section-content">
            <table class="financial-overview">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Valeur</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Revenus Totaux</td>
                        <td class="metric-value">{{ number_format($financialOverview['total_revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Bénéfice Brut</td>
                        <td class="metric-value">{{ number_format($financialOverview['gross_profit'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Bénéfice Net</td>
                        <td class="metric-value">{{ number_format($financialOverview['net_profit'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Marge Bénéficiaire</td>
                        <td class="metric-value">{{ number_format($financialOverview['net_profit_margin'], 1) }}%</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Analyse des Tendances -->
    <div class="section">
        <div class="section-header">Analyse des Tendances</div>
        <div class="section-content">
            <table class="trend-analysis">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Période Actuelle</th>
                        <th>Période Précédente</th>
                        <th>Croissance</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Revenus</td>
                        <td>{{ number_format($financialOverview['total_revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td>{{ number_format($financialOverview['previous_revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td class="{{ $financialOverview['revenue_growth'] >= 0 ? 'growth-positive' : 'growth-negative' }}">
                            {{ $financialOverview['revenue_growth'] >= 0 ? '+' : '' }}{{ $financialOverview['revenue_growth'] }}%
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Performance des Ventes -->
    <div class="section">
        <div class="section-header">Performance des Ventes</div>
        <div class="section-content">
            <table class="metric-table">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Valeur</th>
                        <th>Statut</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Total Ventes</td>
                        <td class="metric-value">{{ number_format($salesPerformance['total_sales'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Valeur Moyenne Commande</td>
                        <td class="metric-value">{{ number_format($salesPerformance['average_order_value'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Top 5 Produits -->
    <div class="section">
        <div class="section-header">Top 5 Produits</div>
        <div class="section-content">
            @if($salesPerformance['top_products']->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th>Produit</th>
                        <th>Quantité Vendue</th>
                        <th>Chiffre d'Affaires ({{ \App\Models\Setting::DEFAULT_CURRENCY }})</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($salesPerformance['top_products'] as $product)
                    <tr>
                        <td>{{ $product->name }}</td>
                        <td>{{ number_format($product->total_quantity ?? 0, 0, ',', ' ') }}</td>
                        <td>{{ number_format($product->total_revenue ?? 0, 0, ',', ' ') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="empty-data">Aucun produit vendu dans cette période</div>
            @endif
        </div>
    </div>

    <!-- Insights Clients -->
    <div class="section">
        <div class="section-header">Insights Clients</div>
        <div class="section-content">
            <table class="metric-table">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Valeur</th>
                        <th>Statut</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Total Clients</td>
                        <td class="metric-value">{{ number_format($customerInsights['total_customers'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-neutral">-</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Clients Actifs</td>
                        <td class="metric-value">{{ number_format($customerInsights['active_customers'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Nouveaux Clients</td>
                        <td class="metric-value">{{ number_format($customerInsights['new_customers'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Valeur Vie Client</td>
                        <td class="metric-value">{{ number_format($customerInsights['customer_lifetime_value'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Inventaire & Opérations -->
    <div class="section">
        <div class="section-header">Inventaire & Opérations</div>
        <div class="section-content">
            <table class="metric-table">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Valeur</th>
                        <th>Statut</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Total Produits</td>
                        <td class="metric-value">{{ number_format($inventoryInsights['total_products'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-neutral">-</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Valeur Inventaire</td>
                        <td class="metric-value">{{ number_format($inventoryInsights['total_inventory_value'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Stock Faible</td>
                        <td class="metric-value">{{ number_format($inventoryInsights['low_stock_products'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge {{ $inventoryInsights['low_stock_products'] > 0 ? 'status-weak' : 'status-good' }}">
                            {{ $inventoryInsights['low_stock_products'] > 0 ? 'Faible' : 'Bon' }}
                        </span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Rupture de Stock</td>
                        <td class="metric-value">{{ number_format($inventoryInsights['out_of_stock_products'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge {{ $inventoryInsights['out_of_stock_products'] > 0 ? 'status-weak' : 'status-good' }}">
                            {{ $inventoryInsights['out_of_stock_products'] > 0 ? 'Faible' : 'Bon' }}
                        </span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Fournisseurs Actifs</td>
                        <td class="metric-value">{{ number_format($operationalMetrics['active_suppliers'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Évaluation des Risques -->
    <div class="section">
        <div class="section-header">Évaluation des Risques</div>
        <div class="section-content">
            <table class="metric-table">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Valeur</th>
                        <th>Statut</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Ratio Dette/Revenus</td>
                        <td class="metric-value">{{ number_format($riskAssessment['debt_to_revenue_ratio'], 1) }}%</td>
                        <td><span class="status-badge {{ $riskAssessment['debt_to_revenue_ratio'] > 50 ? 'status-weak' : 'status-good' }}">
                            {{ $riskAssessment['debt_to_revenue_ratio'] > 50 ? 'Faible' : 'Bon' }}
                        </span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Risque Stock</td>
                        <td class="metric-value">{{ number_format($riskAssessment['inventory_risk'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge {{ $riskAssessment['inventory_risk'] > 0 ? 'status-weak' : 'status-good' }}">
                            {{ $riskAssessment['inventory_risk'] > 0 ? 'Faible' : 'Bon' }}
                        </span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Stock Faible</td>
                        <td class="metric-value">{{ number_format($riskAssessment['low_stock_risk'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge {{ $riskAssessment['low_stock_risk'] > 5 ? 'status-weak' : 'status-good' }}">
                            {{ $riskAssessment['low_stock_risk'] > 5 ? 'Faible' : 'Bon' }}
                        </span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Insights Stratégiques -->
    <div class="section">
        <div class="section-header">Insights Stratégiques</div>
        <div class="section-content">
            @if(count($strategicInsights) > 0)
            <table>
                <thead>
                    <tr>
                        <th>Type</th>
                        <th>Titre</th>
                        <th>Message</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($strategicInsights as $insight)
                    <tr>
                        <td>
                            <span class="status-badge 
                                @if($insight['type'] === 'success') status-positive
                                @elseif($insight['type'] === 'warning') status-weak
                                @elseif($insight['type'] === 'danger') status-negative
                                @else status-neutral @endif">
                                {{ ucfirst($insight['type']) }}
                            </span>
                        </td>
                        <td>{{ $insight['title'] }}</td>
                        <td>{{ $insight['message'] }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="empty-data">Aucun insight stratégique disponible</div>
            @endif
        </div>
    </div>

    <!-- Recommandations -->
    <div class="recommendations">
        <h4>Recommandations</h4>
        <p>
            @if($financialOverview['revenue_growth'] < 0)
                <strong>Préoccupations de Performance:</strong> Les revenus ont diminué de {{ abs($financialOverview['revenue_growth']) }}% par rapport à la période précédente. 
                Analysez les tendances de vente et considérez des stratégies de relance.
            @elseif($financialOverview['revenue_growth'] > 20)
                <strong>Excellente Performance:</strong> Croissance remarquable de {{ $financialOverview['revenue_growth'] }}%. 
                Maintenez cette dynamique et explorez des opportunités d'expansion.
            @else
                <strong>Performance Stable:</strong> Croissance modérée de {{ $financialOverview['revenue_growth'] }}%. 
                Continuez à optimiser les processus et à surveiller les indicateurs de risque.
            @endif
        </p>
    </div>

    <!-- Guide d'Interprétation -->
    <div class="section">
        <div class="section-header">Guide d'Interprétation des Métriques</div>
        <div class="section-content">
            <div style="padding: 20px; background-color: #f8fafc; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">📊 Aperçu Financier</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Revenus Totaux:</strong> Montant total généré par toutes les ventes dans la période sélectionnée</li>
                    <li><strong>Bénéfice Brut:</strong> Profit avant déduction des dépenses opérationnelles</li>
                    <li><strong>Bénéfice Net:</strong> Profit après déduction de tous les coûts et dépenses</li>
                    <li><strong>Marge Bénéficiaire:</strong> Pourcentage de profit par rapport aux revenus totaux</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #f0f9ff; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">📈 Analyse des Tendances</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Période Actuelle:</strong> Données de la période sélectionnée pour le rapport</li>
                    <li><strong>Période Précédente:</strong> Données de la période équivalente précédente pour comparaison</li>
                    <li><strong>Croissance:</strong> Pourcentage de variation entre les deux périodes (positif = amélioration, négatif = baisse)</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #f0fdf4; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">🏆 Performance des Ventes</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Total Ventes:</strong> Nombre total de transactions complétées</li>
                    <li><strong>Valeur Moyenne Commande:</strong> Montant moyen par transaction</li>
                    <li><strong>Top Produits:</strong> Produits les plus vendus par quantité et chiffre d'affaires</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #fefce8; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">👥 Insights Clients</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Total Clients:</strong> Nombre total de clients dans votre base de données</li>
                    <li><strong>Clients Actifs:</strong> Clients ayant effectué au moins une commande dans la période</li>
                    <li><strong>Nouveaux Clients:</strong> Clients qui ont effectué leur première commande</li>
                    <li><strong>Valeur Vie Client:</strong> Valeur moyenne générée par client sur sa durée de vie</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #fdf2f8; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">📦 Inventaire & Opérations</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Valeur Inventaire:</strong> Valeur totale des stocks disponibles</li>
                    <li><strong>Stock Faible:</strong> Produits nécessitant un réapprovisionnement</li>
                    <li><strong>Rupture de Stock:</strong> Produits complètement épuisés</li>
                    <li><strong>Fournisseurs Actifs:</strong> Nombre de fournisseurs avec des commandes récentes</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #f3e8ff; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">⚠️ Évaluation des Risques</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Ratio Dette/Revenus:</strong> Pourcentage des dettes par rapport aux revenus (risque financier)</li>
                    <li><strong>Risque Stock:</strong> Nombre de produits en rupture de stock</li>
                    <li><strong>Stock Faible:</strong> Nombre de produits nécessitant un réapprovisionnement urgent</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #fef3c7; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">🎯 Indicateurs de Performance</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Statut "Positif":</strong> Indicateur vert - Performance satisfaisante ou en amélioration</li>
                    <li><strong>Statut "Faible":</strong> Indicateur rouge - Performance nécessitant une attention particulière</li>
                    <li><strong>Statut "Bon":</strong> Indicateur vert - Métrique dans une fourchette acceptable</li>
                    <li><strong>Croissance Positive (+):</strong> Amélioration par rapport à la période précédente</li>
                    <li><strong>Croissance Négative (-):</strong> Détérioration par rapport à la période précédente</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #fef2f2; border-radius: 8px; border-left: 4px solid #dc2626;">
                <h4 style="color: #dc2626; margin: 0 0 10px 0; font-size: 13px; font-weight: bold;">💡 Comment Utiliser Ce Rapport Business Intelligence</h4>
                <ul style="margin: 0; padding-left: 20px; color: #7f1d1d; font-size: 11px; line-height: 1.6;">
                    <li><strong>Analysez les tendances:</strong> Surveillez l'évolution des métriques clés dans le temps</li>
                    <li><strong>Identifiez les risques:</strong> Portez attention aux indicateurs d'alerte et aux ratios de risque</li>
                    <li><strong>Optimisez l'inventaire:</strong> Gérez les stocks en fonction des niveaux d'alerte</li>
                    <li><strong>Améliorez la rentabilité:</strong> Concentrez-vous sur les marges et la croissance</li>
                    <li><strong>Planifiez stratégiquement:</strong> Utilisez les insights pour prendre des décisions éclairées</li>
                    <li><strong>Surveillez la santé financière:</strong> Maintenez un équilibre entre croissance et stabilité</li>
                </ul>
            </div>
        </div>
    </div>
</body>
</html>
