<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Bons de commande' => route('purchase-orders.index'),
        $purchaseOrder->reference => null,
    ]">
        <x-slot name="action">
            <x-dashboard.purchase-orders.dropdown :purchaseOrder="$purchaseOrder" />
        </x-slot>
    </x-dashboard.breadcrumb>


    <div class="flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <!-- Purchase Order Details -->
            <x-basics.card title="Informations de la Commande" subtitle="Détails complets de la commande">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Supplier Info -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-buildings text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Fournisseur</h3>
                                <p class="text-sm text-gray-600">
                                    {{ $purchaseOrder->supplier?->name ?? 'Non défini' }}
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Order Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Date de commande</h3>
                                <p class="text-sm text-gray-600">
                                    {{ $purchaseOrder->order_date?->format('d/m/Y') ?? 'Non défini' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Expected Delivery -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-truck text-orange-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Livraison prévue</h3>
                                <p class="text-sm text-gray-600">
                                    {{ $purchaseOrder->expected_delivery_date?->format('d/m/Y') ?? 'Non défini' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-info text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Statut</h3>
                                <p class="text-sm text-gray-600">
                                    {{ $purchaseOrder->getStatusLabel() }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                @if ($purchaseOrder->notes)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Notes</h3>
                                <p class="text-sm text-gray-600">{{ $purchaseOrder->notes }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>

            <!-- Order Items -->
            <x-basics.card title="Articles Commandés" subtitle="Liste des produits commandés">
                @if ($purchaseOrder->items->count() > 0)
                    <div class="space-y-4">
                        @foreach ($purchaseOrder->items as $item)
                            <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                                <div
                                    class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
                                    <div class="flex items-center space-x-4 w-full sm:w-auto">
                                        <div
                                            class="w-12 h-12 bg-gradient-to-br from-green-100 to-green-200 rounded-lg flex items-center justify-center flex-shrink-0">
                                            <i class="ph ph-package text-green-600 text-lg"></i>
                                        </div>
                                        <div class="min-w-0 flex-1">
                                            <h3 class="font-semibold text-gray-900 text-lg truncate">
                                                {{ $item->product->name }}</h3>
                                            <p class="text-sm text-gray-500">
                                                {{ $item->product->category->name ?? 'Sans catégorie' }}</p>
                                            <p class="text-xs text-gray-400">
                                                Exp:
                                                {{ $item->stockEntries->first()?->expiry_date?->format('d/m/Y') ?? 'Non défini' }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="w-full sm:w-auto">
                                        <div class="grid grid-cols-2 gap-4 sm:flex sm:items-center sm:space-x-6">
                                            <div class="text-center">
                                                <p class="text-xs sm:text-sm text-gray-500">Quantité</p>
                                                <p class="font-semibold text-gray-900 text-sm sm:text-base">
                                                    {{ $item->quantity }}
                                                    <span
                                                        class="hidden sm:inline">{{ Str::plural($item->product?->purchaseUnit?->name ?? '', $item->quantity) }}</span>
                                                </p>
                                            </div>
                                            <div class="text-center">
                                                <p class="text-xs sm:text-sm text-gray-500">Prix unitaire</p>
                                                <p class="font-semibold text-gray-900 text-sm sm:text-base">
                                                    {{ number_format($item->product->purchase_price, 2) }}
                                                    {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Summary -->
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <div class="flex flex-col sm:flex-row justify-between items-center gap-4">
                            <div class="text-center sm:text-right">
                                <p class="text-sm text-gray-500">Total des articles</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $purchaseOrder->items->count() }}</p>
                            </div>
                            <div class="text-center sm:text-right">
                                <p class="text-sm text-gray-500">Montant total</p>
                                <p class="text-2xl sm:text-3xl font-bold text-green-600">
                                    {{ number_format($purchaseOrder->getTotalAmount() ?? 0, 0, ',', ' ') }}
                                    {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </p>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="text-center py-8">
                        <div class="text-gray-500 mb-4">
                            <i class="ph ph-package text-4xl"></i>
                        </div>
                        <p class="text-gray-600 mb-4">Aucun article dans cette commande</p>
                    </div>
                @endif
            </x-basics.card>

        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.purchase-orders.sidebar :purchaseOrder="$purchaseOrder" />
        </div>
    </div>
</div>
