<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Produits' => route('products.index'),
        $product->name => null,
    ]">

        <x-slot name="action">
            @if (auth()->user()->isAdmin() || auth()->user()->isOwner())
                <x-dashboard.products.dropdown :product="$product" />
            @endif
        </x-slot>

    </x-dashboard.breadcrumb>

    <div class="flex gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Informations du Produit" subtitle="Détails complets du produit">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Product Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-package text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom du produit</h3>
                                <p class="text-sm text-gray-600">{{ $product->name }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- SKU -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-barcode text-gray-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">SKU (Code produit)</h3>
                                <p class="text-sm text-gray-600 font-mono">{{ $product->sku ?? 'Non défini' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Selling Price -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-currency-dollar text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Prix de vente</h3>
                                <p class="text-sm text-gray-600">
                                    {{ $product->selling_price ? number_format($product->selling_price, 2) . ' ' . \App\Models\Setting::DEFAULT_CURRENCY : 'Non défini' }}
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Category -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-tag text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Catégorie</h3>
                                <p class="text-sm text-gray-600">{{ $product->category->name ?? 'Sans catégorie' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Generic Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-indigo-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-stethoscope text-indigo-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom générique</h3>
                                <p class="text-sm text-gray-600">{{ $product->generic_name ?? 'Sans nom générique' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Brand -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-trademark text-orange-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Marque</h3>
                                <p class="text-sm text-gray-600">{{ $product->brand ?? 'Sans marque' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Sale Unit -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-cyan-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-ruler text-cyan-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Unité de vente</h3>
                                <p class="text-sm text-gray-600">{{ $product->saleUnit?->name ?? 'Sans unité' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Current Stock -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-warehouse text-red-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Stock actuel</h3>
                                <p class="text-sm text-gray-600">
                                    {{ $product->current_stock ?? 0 }} {{ $product->saleUnit?->name ?? 'unités' }}
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Purchase Price -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-emerald-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-shopping-cart text-emerald-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Prix d'achat</h3>
                                <p class="text-sm text-gray-600">
                                    {{ $product->purchase_price ? number_format($product->purchase_price, 2) . ' ' . \App\Models\Setting::DEFAULT_CURRENCY : 'Non défini' }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </x-basics.card>

            <!-- Stock History -->
            <x-basics.card title="Historique des Stocks" subtitle="Mouvements de stock récents">
                @if ($product->stockEntries->count() > 0)
                    <div class="space-y-4">
                        @foreach ($product->stockEntries->take(5) as $entry)
                            <div class="flex items-center justify-between p-4 rounded-lg bg-gray-100 ">
                                <div>
                                    <p class="font-medium text-gray-900"> Batch: <a
                                            href="{{ route('stock-entries.show', $entry) }}"
                                            class="text-blue-600 hover:text-blue-900">
                                            {{ $entry->batch_no }}
                                        </a>
                                    </p>
                                    <p class="text-sm text-gray-600">
                                        · Date: {{ $entry->created_at->format('d/m/Y') }}
                                    </p>
                                    @if ($entry->purchaseOrder)
                                        <p class="text-xs text-gray-600">
                                            · PO: {{ $entry->purchaseOrder->reference }}
                                        </p>
                                    @endif
                                    @if ($entry->expiry_date)
                                        <p class="text-xs text-gray-600">
                                            · Exp: {{ $entry->expiry_date->format('d/m/Y') }}
                                        </p>
                                    @endif
                                </div>
                                <div class="text-right">
                                    <p class="font-semibold text-gray-900">
                                        {{ $entry->quantity }}
                                        {{ Str::plural($entry->purchaseUnit?->name ?? 'unité', $entry->quantity) }}
                                    </p>
                                    {{ $entry->getSourceTypeLabel() }}
                                </div>
                            </div>
                        @endforeach

                        @if ($product->stockEntries->count() > 5)
                            <div class="text-center pt-4">
                                <x-basics.button-link
                                    href="{{ route('stock-entries.index') }}?product_id={{ $product->id }}"
                                    variant="outline" class="w-full">
                                    Voir tout l'historique
                                </x-basics.button-link>
                            </div>
                        @endif
                    </div>
                @else
                    <div class="text-center py-12">
                        <div class="text-gray-500">
                            <i class="ph ph-package text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucun historique de stock trouvé</p>
                            <p class="text-sm">Commencez par créer votre premier historique de stock</p>
                        </div>
                    </div>
                @endif
            </x-basics.card>

        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.products.sidebar :product="$product" />
        </div>
    </div>
</div>
