<form wire:submit.prevent="activate">
    @if ($error && $error_message)
        <div class="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="ph ph-warning text-red-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-red-800">{{ $error_message }}</p>
                </div>
            </div>
        </div>
    @endif

    <div class="text-gray-600">
        Êtes-vous sûr de vouloir activer cet établissement ?
        <p class="mb-4">
            Votre établissement sera activé et accessible par tous les utilisateurs. 
            Vous serez capable de recevoir des prescriptions de médicaments à traiter.
        </p>
        <p class="mb-0">
            <input type="checkbox" name="accept_terms" id="accept_terms">
            <label for="accept_terms">J'accepte les <a href="{{ route('terms') }}" target="_blank" class="text-blue-500">conditions d'utilisation</a> et la <a href="{{ route('privacy') }}" target="_blank" class="text-blue-500">politique de confidentialité</a>.</label>
        </p>
    </div>

    <div class="mt-6 border-t border-gray-200 pt-6">

        <x-basics.button variant="success" :disabled="$activating" type="submit" class="w-full" wireTarget="activate">
            <span wire:loading.remove>Activer l'établissement</span>
            <span wire:loading wire:target="activate">Activation en cours...</span>
        </x-basics.button>

    </div>
</form>
