<?php

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use function Livewire\Volt\{state, mount};

state(['showActivateModal' => false, 'showDeactivateModal' => false, 'activating' => false, 'deactivating' => false]);

mount(function () {
    // Check if user is authenticated and is owner
    if (!Auth::check() || !Auth::user()->isOwner()) {
        abort(403);
    }
});

$activate = function () {
    $this->activating = true;
    
    try {
        $result = activateMerchant();
        
        if ($result['success']) {
            session()->flash('success', $result['message'] ?? 'Établissement activé avec succès');
            $this->showActivateModal = false;
        } else {
            session()->flash('error', $result['message'] ?? 'Erreur lors de l\'activation');
        }
    } catch (\Exception $e) {
        session()->flash('error', 'Erreur lors de l\'activation: ' . $e->getMessage());
    } finally {
        $this->activating = false;
    }
};

$deactivate = function () {
    $this->deactivating = true;
    
    try {
        $result = deactivateMerchant();
        
        if ($result['success']) {
            session()->flash('success', $result['message'] ?? 'Établissement désactivé avec succès');
            $this->showDeactivateModal = false;
        } else {
            session()->flash('error', $result['message'] ?? 'Erreur lors de la désactivation');
        }
    } catch (\Exception $e) {
        session()->flash('error', 'Erreur lors de la désactivation: ' . $e->getMessage());
    } finally {
        $this->deactivating = false;
    }
};

?>

<div>
    @if (isMerchantActive())
        <x-basics.button variant="danger" wire:click="$set('showDeactivateModal', true)" leftIcon="power">
            Désactiver l'établissement
        </x-basics.button>
    @else
        <x-basics.button variant="success" wire:click="$set('showActivateModal', true)" leftIcon="power">
            Activer l'établissement
        </x-basics.button>
    @endif

    <!-- Activate Modal -->
    <x-basics.modal show="showActivateModal" title="Activer l'établissement" description="">
        <div class="text-gray-600">
            Êtes-vous sûr de vouloir activer cet établissement ?
            <p class="mb-0">
                L'établissement <strong>{{ settings('merchant_name') }}</strong> sera activé et accessible.
            </p>
        </div>
        @slot('footer')
            <div class="flex gap-2">
                <x-basics.button variant="secondary" wire:click="$set('showActivateModal', false)" class="flex-1">
                    Annuler
                </x-basics.button>
                <x-basics.button variant="success" wire:click="activate" :disabled="$activating" class="flex-1">
                    @if ($activating)
                        <span wire:loading wire:target="activate">Activation...</span>
                    @else
                        Activer l'établissement
                    @endif
                </x-basics.button>
            </div>
        @endslot
    </x-basics.modal>

    <!-- Deactivate Modal -->
    <x-basics.modal show="showDeactivateModal" title="Désactiver l'établissement" description="">
        <div class="text-gray-600">
            Êtes-vous sûr de vouloir désactiver cet établissement ?
            <p class="mb-0">
                L'établissement <strong>{{ settings('merchant_name') }}</strong> sera désactivé et ne sera plus accessible.
            </p>
            <p class="text-sm text-orange-600 mt-2">
                Pour désactiver cet établissement, vous devez vérifier votre connexion internet.
            </p>
        </div>
        @slot('footer')
            <div class="flex gap-2">
                <x-basics.button variant="secondary" wire:click="$set('showDeactivateModal', false)" class="flex-1">
                    Annuler
                </x-basics.button>
                <x-basics.button variant="danger" wire:click="deactivate" :disabled="$deactivating" class="flex-1">
                    @if ($deactivating)
                        <span wire:loading wire:target="deactivate">Désactivation...</span>
                    @else
                        Désactiver l'établissement
                    @endif
                </x-basics.button>
            </div>
        @endslot
    </x-basics.modal>
</div>
