<div class="container mx-auto" x-data="{ showCreateCategoryModal: false }">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Catégories de Dépenses' => null,
    ]">
        <x-slot name="action">
            <x-basics.button @click="showCreateCategoryModal = true" variant="primary">
                <i class="ph ph-plus mr-2"></i>
                Nouvelle Catégorie
            </x-basics.button>
        </x-slot>
    </x-dashboard.breadcrumb>

    <!-- Filters Section -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form action="{{ route('expense-categories.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <x-basics.input name="search" label="Rechercher par nom..." placeholder="Rechercher par nom..."
                    value="{{ request('search') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.select name="status" label="Statut" placeholder="Tous" :options="$statuses" optionLabel="label" optionValue="value"
                    value="{{ request('status') }}" mb="0" />
            </div>

            <div class="flex gap-2">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Filtrer
                </x-basics.button>
                @if (request('search') || request('status'))
                    <x-basics.button-link href="{{ route('expense-categories.index') }}" variant="outline">
                        <i class="ph ph-arrow-clockwise mr-2"></i>
                        Reset
                    </x-basics.button-link>
                @endif
            </div>
        </form>
    </div>

    <!-- Categories Table -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Liste des catégories</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($categories->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Catégorie</th>
                            <th class="p-3 text-left font-medium text-gray-700">Nombre de dépenses</th>
                            <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                            <th class="p-3 text-left font-medium text-gray-700">Création</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($categories as $category)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration + ($categories->currentPage() - 1) * $categories->perPage() }}.
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link href="{{ route('expense-categories.show', $category) }}" wire:navigate size="md">
                                        {{ $category->name ?? '—' }}
                                    </x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $category->expenses_count ?? 0 }}
                                </td>
                                <td class="px-3 py-2">
                                    {!! $category->getStatusBadge() !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $category->created_at->format('d/m/Y') }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-folder-open text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucune catégorie de dépense trouvée</p>
                        <p class="text-sm">Commencez par créer votre première catégorie</p>
                    </div>
                </div>
            @endif
        </div>

        @if ($categories->hasPages())
            <div class="px-4 py-4 border-t">
                {{ $categories->links() }}
            </div>
        @endif
    </div>

    <!-- Create Category Modal -->
    <form action="{{ route('expense-categories.store') }}" method="POST">
        @csrf
        <x-basics.modal :show="'showCreateCategoryModal'" title="Créer une catégorie de dépense" size="lg">
            <x-basics.input name="name" label="Nom de la catégorie"
                placeholder="Ex. Fournitures de bureau, Maintenance, Marketing..." :error="$errors->first('name')" required />

            <x-slot name="footer">
                <x-basics.button type="submit" class="w-full">
                    Créer la catégorie
                </x-basics.button>
            </x-slot>
        </x-basics.modal>
    </form>
</div>
