<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Dettes' => route('debts.index'),
        $debt->debt_number => null,
    ]">
        <x-slot name="action">
            <x-dashboard.debts.dropdown :debt="$debt" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <!-- Debt Details -->
            <x-basics.card title="Informations de la Dette" subtitle="Détails complets de la dette">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Customer Info -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-user text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Client</h3>
                                <x-basics.link href="{{ route('customers.show', $debt->customer) }}" variant="link"
                                    size="normal" class="text-sm text-gray-600">
                                    {{ $debt->customer->name }}
                                </x-basics.link>
                            </div>
                        </div>
                    </div>

                    <!-- Sale Info -->
                    @if ($debt->sale)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-receipt text-green-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Vente associée</h3>
                                    <x-basics.link href="{{ route('sales.show', $debt->sale) }}" variant="link"
                                        size="normal" class="text-sm text-gray-600">
                                        {{ $debt->sale->sale_number }}
                                    </x-basics.link>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Total Amount -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-currency-dollar text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Montant total</h3>
                                <p class="text-sm text-gray-600 font-medium">{{ $debt->formatted_total_debt_amount }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Paid Amount -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-check-circle text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Montant payé</h3>
                                <p class="text-sm text-gray-600 font-medium text-green-600">{{ $debt->formatted_paid_amount }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Remaining Amount -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-warning text-red-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Montant restant</h3>
                                <p class="text-sm text-gray-600 font-medium text-red-600">{{ $debt->formatted_remaining_amount }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-info text-orange-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Statut</h3>
                                <p class="text-sm text-gray-600 font-medium">{{ $debt->status_label }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Due Date -->
                    @if ($debt->due_date)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 {{ $debt->isOverdue() ? 'bg-red-100' : 'bg-blue-100' }} rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-calendar {{ $debt->isOverdue() ? 'text-red-600' : 'text-blue-600' }}"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Date d'échéance</h3>
                                    <p class="text-sm {{ $debt->isOverdue() ? 'text-red-600' : 'text-gray-600' }} font-medium">
                                        {{ $debt->due_date->format('d/m/Y') }}
                                        @if ($debt->isOverdue())
                                            <br><span class="text-xs text-red-500">
                                                {{ abs($debt->days_until_due) }} jour{{ abs($debt->days_until_due) > 1 ? 's' : '' }} de retard
                                            </span>
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Creation Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-clock text-gray-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Date de création</h3>
                                <p class="text-sm text-gray-600 font-medium">{{ $debt->created_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                @if ($debt->notes)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Notes</h3>
                                <p class="text-sm text-gray-600">{{ $debt->notes }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>

            <!-- Payment History -->
            @if ($debt->payments->count() > 0)
                <x-basics.card title="Historique des Paiements" subtitle="Liste des paiements effectués">
                    <div class="space-y-4">
                        @foreach ($debt->payments->sortByDesc('payment_date') as $payment)
                            <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
                                    <div class="flex items-center space-x-4 w-full sm:w-auto">
                                        <div class="w-12 h-12 bg-gradient-to-br from-green-100 to-green-200 rounded-lg flex items-center justify-center flex-shrink-0">
                                            <i class="ph ph-check-circle text-green-600 text-lg"></i>
                                        </div>
                                        <div class="min-w-0 flex-1">
                                            <h3 class="font-semibold text-gray-900 text-lg">
                                                {{ number_format($payment->amount, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                            </h3>
                                            <p class="text-sm text-gray-500">
                                                {{ ucfirst(str_replace('_', ' ', $payment->payment_method)) }}
                                                @if ($payment->reference)
                                                    • {{ $payment->reference }}
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                    <div class="w-full sm:w-auto">
                                        <div class="grid grid-cols-1 gap-4 sm:flex sm:items-center sm:space-x-6">
                                            <div class="text-center sm:text-right">
                                                <p class="text-xs sm:text-sm text-gray-500">Date</p>
                                                <p class="font-semibold text-gray-900 text-sm sm:text-base">
                                                    {{ $payment->payment_date->format('d/m/Y') }}
                                                </p>
                                            </div>
                                            <div class="text-center sm:text-right">
                                                <p class="text-xs sm:text-sm text-gray-500">
                                                    Enregistré par
                                                </p>
                                                <p class="font-semibold text-gray-900 text-sm sm:text-base">
                                                    {{ $payment->user?->full_name ?? '—' }}
                                                </p>
                                            </div>
                                            @if ($payment->notes)
                                                <div class="text-center sm:text-right">
                                                    <p class="text-xs sm:text-sm text-gray-500">Notes</p>
                                                    <p class="font-semibold text-gray-900 text-sm sm:text-base">
                                                        {{ $payment->notes }}
                                                    </p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Summary -->
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <div class="flex flex-col sm:flex-row justify-between items-center gap-4">
                            <div class="text-center sm:text-right">
                                <p class="text-sm text-gray-500">Total des paiements</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $debt->payments->count() }}</p>
                            </div>
                            <div class="text-center sm:text-right">
                                <p class="text-sm text-gray-500">Montant total payé</p>
                                <p class="text-2xl sm:text-3xl font-bold text-green-600">
                                    {{ number_format($debt->paid_amount, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </p>
                            </div>
                        </div>
                    </div>
                </x-basics.card>
            @else
                <x-basics.card title="Historique des Paiements" subtitle="Liste des paiements effectués">
                    <div class="text-center py-8">
                        <div class="text-gray-500">
                            <i class="ph ph-receipt text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucun paiement enregistré</p>
                            <p class="text-sm">Aucun paiement n'a encore été effectué pour cette dette</p>
                        </div>
                    </div>
                </x-basics.card>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.debts.sidebar :debt="$debt" />
        </div>
    </div>
</div>
