<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dettes' => route('debts.index'),
        $debt->debt_number => route('debts.show', $debt),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.debts.dropdown :debt="$debt" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <form wire:submit.prevent="save" class="space-y-6">

                <x-basics.card title="Modifier la Dette" subtitle="Modifiez les informations de la dette">
                    <x-slot name="action">
                        <x-basics.flash :model="'success'" :timeout="3000" />
                        <x-basics.flash :model="'error'" :message="$errorMessage" :timeout="3000" />
                    </x-slot>

                    <div class="space-y-4">
                        <div>
                            <x-basics.input name="due_date" wire:model="due_date" label="Date d'échéance" type="date"
                                :error="$errors->first('due_date')" />
                        </div>

                        <div>
                            <x-basics.textarea name="notes" wire:model="notes" label="Notes"
                                placeholder="Notes supplémentaires sur cette dette..." :error="$errors->first('notes')" />
                        </div>

                    </div>

                    <!-- Form Actions -->
                    <div class="flex gap-3 pt-6 border-t">
                        <x-basics.button type="submit" :disabled="$loading" class="flex-1">
                            @if ($loading)
                                <i class="ph ph-spinner ph-spin mr-2"></i>
                                Enregistrement...
                            @else
                                <i class="ph ph-check mr-2"></i>
                                Enregistrer
                            @endif
                        </x-basics.button>

                    </div>
                </x-basics.card>
            </form>

        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.debts.sidebar :debt="$debt" />
        </div>
    </div>
</div>
