<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Clients' => route('customers.index'),
        $customer->name => null,
    ]">
        <x-slot name="action">
            <x-dashboard.customers.dropdown :customer="$customer" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <!-- Customer Information -->
            <x-basics.card title="Informations du Client" subtitle="Détails complets du client">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Customer Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-user text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom</h3>
                                <p class="text-sm text-gray-600">{{ $customer->name ?? '—' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Phone -->
                    @if ($customer->contact?->phone)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-phone text-green-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Téléphone</h3>
                                    <p class="text-sm text-gray-600">{{ $customer->contact->phone ?? '—' }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Email -->
                    @if ($customer->contact?->email)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-envelope text-purple-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Email</h3>
                                    <p class="text-sm text-gray-600">{{ $customer->contact->email ?? '—' }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                @if ($customer->address?->description)
                    <div class="mt-6 bg-blue-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-map-pin text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Adresse</h3>
                                <p class="text-sm text-gray-600">{{ $customer->address->description ?? '—' }}</p>
                            </div>
                        </div>
                    </div>
                @endif

                @if ($customer->notes)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Notes</h3>
                                <p class="text-sm text-gray-600">{{ $customer->notes ?? '—' }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>

            <!-- Recent Sales -->
            <x-basics.card title="Ventes Récentes" subtitle="Dernières ventes de ce client">
                @if ($customer->sales->count() > 0)
                    <div class="space-y-4">
                        @foreach ($customer->sales->take(5) as $sale)
                            <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
                                    <div class="flex items-center space-x-4 w-full sm:w-auto">
                                        <div class="w-12 h-12 bg-gradient-to-br from-blue-100 to-blue-200 rounded-lg flex items-center justify-center flex-shrink-0">
                                            <i class="ph ph-receipt text-blue-600 text-lg"></i>
                                        </div>
                                        <div class="min-w-0 flex-1">
                                            <h3 class="font-semibold text-gray-900 text-lg truncate">
                                                <x-basics.link href="{{ route('sales.show', $sale) }}" wire:navigate variant="link" class="text-blue-600 hover:text-blue-800">
                                                    {{ $sale->sale_number ?? '—' }}
                                                </x-basics.link>
                                            </h3>
                                            <p class="text-sm text-gray-500">
                                                {{ $sale->created_at?->format('d F Y à H:i') ?? '—' }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="w-full sm:w-auto">
                                        <div class="flex flex-col sm:items-end gap-2">
                                            <p class="font-bold text-lg text-blue-600">
                                                {{ number_format($sale->total_amount ?? 0, 0, ',', ' ') }}
                                                {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                            </p>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $sale->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                                {{ $sale->status === 'completed' ? 'Terminée' : 'En cours' }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        @if ($customer->sales->count() > 5)
                            <div class="text-center pt-4">
                                <x-basics.button-link href="{{ route('customers.sales.index', $customer) }}" variant="outline" class="w-full">
                                    Voir toutes les ventes ({{ $customer->sales->count() }})
                                </x-basics.button-link>
                            </div>
                        @elseif ($customer->sales->count() > 0)
                            <div class="text-center pt-4">
                                <x-basics.button-link href="{{ route('customers.sales.index', $customer) }}" variant="outline" class="w-full">
                                    Voir toutes les ventes
                                </x-basics.button-link>
                            </div>
                        @endif
                    </div>
                @else
                    <div class="text-center py-12">
                        <div class="text-gray-500">
                            <i class="ph ph-package text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucune vente trouvée</p>
                            <p class="text-sm">Commencez par créer votre première vente</p>
                        </div>
                    </div>
                @endif
            </x-basics.card>

            <!-- Recent Debts -->
            <x-basics.card title="Dettes Récentes" subtitle="Dernières dettes de ce client">
                @if ($customer->debtRecords->count() > 0)
                    <div class="space-y-4">
                        @foreach ($customer->debtRecords->take(5) as $debt)
                            <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
                                    <div class="flex items-center space-x-4 w-full sm:w-auto">
                                        <div class="w-12 h-12 bg-gradient-to-br from-red-100 to-red-200 rounded-lg flex items-center justify-center flex-shrink-0">
                                            <i class="ph ph-credit-card text-red-600 text-lg"></i>
                                        </div>
                                        <div class="min-w-0 flex-1">
                                            <h3 class="font-semibold text-gray-900 text-lg truncate">
                                                <x-basics.link href="{{ route('sales.show', $debt->sale) }}" wire:navigate variant="link" class="text-red-600 hover:text-red-800">
                                                    {{ $debt->sale?->sale_number ?? '—' }}
                                                </x-basics.link>
                                            </h3>
                                            <p class="text-sm text-gray-500">
                                                {{ $debt->created_at?->format('d F Y à H:i') ?? '—' }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="w-full sm:w-auto">
                                        <div class="flex flex-col sm:items-end gap-2">
                                            <p class="font-bold text-lg text-red-600">
                                                {{ number_format($debt->remaining_amount ?? 0, 0, ',', ' ') }}
                                                {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                            </p>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $debt->status === 'paid' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                                {{ $debt->status === 'paid' ? 'Payée' : 'En attente' }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        @if ($customer->debtRecords->count() > 5)
                            <div class="text-center pt-4">
                                <x-basics.button-link href="{{ route('customers.debts.index', $customer) }}" variant="outline" class="w-full">
                                    Voir toutes les dettes ({{ $customer->debtRecords->count() }})
                                </x-basics.button-link>
                            </div>
                        @elseif ($customer->debtRecords->count() > 0)
                            <div class="text-center pt-4">
                                <x-basics.button-link href="{{ route('customers.debts.index', $customer) }}" variant="outline" class="w-full">
                                    Voir toutes les dettes
                                </x-basics.button-link>
                            </div>
                        @endif
                    </div>
                @else
                    <div class="text-center py-12">
                        <div class="text-gray-500">
                            <i class="ph ph-package text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucune dette trouvée</p>
                            <p class="text-sm">Commencez par créer votre première dette</p>
                        </div>
                    </div>
                @endif
            </x-basics.card>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <!-- Customer Sidebar Component -->
            <x-dashboard.customers.sidebar :customer="$customer" />
        </div>
    </div>
</div>
