<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Clients' => route('customers.index'),
        $customer->name => route('customers.show', $customer),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.customers.dropdown :customer="$customer" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <!-- General Information -->
            <form wire:submit.prevent="saveGeneral">
                <x-basics.card title="Informations générales" subtitle="Nom et notes du client">
                    <x-slot name="action">
                        <x-basics.flash :model="'general_success'" :timeout="3000" />
                        <x-basics.flash :model="'general_error'" :message="$general_error_message" :timeout="5000" />
                    </x-slot>

                    <form wire:submit.prevent="saveGeneral">
                        <div class="space-y-4">
                            <x-basics.input wire:model="name" name="name" label="Nom complet"
                                placeholder="Nom et prénom" required :error="$errors->first('name')" />

                            <x-basics.textarea wire:model="notes" name="notes" label="Notes (optionnel)"
                                placeholder="Ajouter des remarques importantes..." rows="3" :error="$errors->first('notes')" />
                        </div>

                        <x-slot name="footer">
                            <x-basics.button type="submit" :disabled="$general_loading" leftIcon="floppy-disk" class="w-full">
                                <span wire:loading.remove wire:target="saveGeneral">Enregistrer les informations</span>
                                <span wire:loading wire:target="saveGeneral">Enregistrement...</span>
                            </x-basics.button>
                        </x-slot>
                    </form>
                </x-basics.card>
            </form>

            <!-- Contact Information -->
            <form wire:submit.prevent="saveContact">
                <x-basics.card title="Informations de contact" subtitle="Téléphone et email du client">
                    <x-slot name="action">
                        <x-basics.flash :model="'contact_success'" :timeout="3000" />
                    </x-slot>

                    <form wire:submit.prevent="saveContact">
                        <div class="grid grid-cols-1 gap-6 lg:grid-cols-2">
                            <x-basics.input wire:model="phone" name="phone" label="Téléphone"
                                placeholder="Numéro de téléphone" required :error="$errors->first('phone')" />

                            <x-basics.input wire:model="email" name="email" label="Email" type="email"
                                placeholder="adresse@email.com" :error="$errors->first('email')" />
                        </div>

                        <x-basics.flash model="contact_error" :message="$contact_error_message" variant="error" :timeout="5000" />

                        <x-slot name="footer">
                            <x-basics.button type="submit" :disabled="$contact_loading" leftIcon="floppy-disk" class="w-full">
                                <span wire:loading.remove wire:target="saveContact">Enregistrer les contacts</span>
                                <span wire:loading wire:target="saveContact">Enregistrement...</span>
                            </x-basics.button>
                        </x-slot>
                    </form>
                </x-basics.card>
            </form>

            <!-- Address Information -->
            <form wire:submit.prevent="saveAddress">
                <x-basics.card title="Adresse" subtitle="Adresse du client">
                    <x-slot name="action">
                        <x-basics.flash :model="'address_success'" :timeout="3000" />
                    </x-slot>

                    <form wire:submit.prevent="saveAddress">
                        <div class="space-y-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <x-basics.select name="province_id" wire:model.live="province_id" label="Province"
                                    :options="$provinces" optionValue="id" optionLabel="name"
                                    placeholder="Sélectionner une province" :error="$errors->first('province_id')" />

                                <x-basics.select name="city_id" wire:model.live="city_id" label="Ville"
                                    :options="$cities" optionValue="id" optionLabel="name"
                                    placeholder="Sélectionner une ville" :error="$errors->first('city_id')" />
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <x-basics.input wire:model="commune" name="commune" label="Commune"
                                    placeholder="Ex. Kalamu" :error="$errors->first('commune')" />

                                <x-basics.input wire:model="quarter" name="quarter" label="Quartier"
                                    placeholder="Ex. front" :error="$errors->first('quarter')" />
                            </div>

                            <div>
                                <x-basics.input wire:model="description" name="description" label="Description"
                                    placeholder="Ex. Av. de la République, No. 123" :error="$errors->first('description')" />
                            </div>
                        </div>

                        <x-basics.flash model="address_error" :message="$address_error_message" variant="error" :timeout="5000" />

                        <x-slot name="footer">
                            <x-basics.button type="submit" :disabled="$address_loading" leftIcon="floppy-disk" class="w-full">
                                <span wire:loading.remove wire:target="saveAddress">Enregistrer l'adresse</span>
                                <span wire:loading wire:target="saveAddress">Enregistrement...</span>
                            </x-basics.button>
                        </x-slot>
                    </form>
                </x-basics.card>
            </form>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.customers.sidebar :customer="$customer" />
        </div>
    </div>
</div>
