<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Conversations' => route('conversations.index'),
        $clientName => null,
    ]">
        <x-slot name="action">
            <x-basics.button type="button" wire:click="refreshConversation" wire:loading.attr="disabled">
                <i class="ph ph-arrows-clockwise mr-2"></i>
                Actualiser
            </x-basics.button>
        </x-slot>
    </x-dashboard.breadcrumb>

    @if ($errorMessage)
        <x-basics.alert :type="$offlineMode ? 'warning' : 'danger'" :message="$errorMessage" class="mt-4" />
    @endif

    @if ($conversation)

    <div class="mt-6 grid gap-6 lg:grid-cols-3">
        <div class="lg:col-span-2">
            <div class="bg-white border border-gray-300 rounded shadow relative">
                <div wire:loading.flex class="absolute inset-0 bg-white/70 backdrop-blur-sm z-10 items-center justify-center">
                    <x-basics.spinner size="lg" text="Chargement de la conversation..." />
                </div>

                <div class="p-5 border-b flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                    <div>
                        <h2 class="text-xl font-semibold text-gray-900">{{ $clientName }}</h2>
                        <p class="text-sm text-gray-500 flex items-center gap-3 mt-1">
                            <span class="inline-flex items-center gap-1">
                                <i class="ph ph-clock"></i>
                                Mise à jour : {{ isset($conversation['conversation']['updated_at']) ? \Carbon\Carbon::parse($conversation['conversation']['updated_at'])->format('d/m/Y H:i') : '—' }}
                            </span>
                        </p>
                    </div>
                </div>

                <div class="p-4 h-[75vh] overflow-y-auto space-y-4 bg-gray-50" id="messages-container">
                    @forelse ($messages as $message)
                        @php
                            $isUser = ($message['sender_type'] ?? '') === 'user';
                            $timestamp = $message['created_at'] ?? null;
                            $timestamp = $timestamp ? \Carbon\Carbon::parse($timestamp)->format('d/m/Y H:i') : null;
                            $author = $isUser ? $clientName : 'Vous';
                        @endphp
                        <div class="flex {{ $isUser ? 'justify-start' : 'justify-end' }}">
                            <div class="max-w-[80%]">
                                <div class="text-xs text-gray-500 mb-1 {{ $isUser ? 'text-left' : 'text-right' }}">
                                    {{ $author }}
                                </div>
                                <div
                                    class="px-4 py-3 rounded-2xl shadow-sm text-sm leading-relaxed {{ $isUser ? 'bg-white text-gray-800 border border-gray-200' : 'bg-indigo-600 text-white' }}">
                                    <p>{{ $message['body'] ?? '—' }}</p>
                                    <span
                                        class="block mt-2 text-xs opacity-80 {{ $isUser ? 'text-gray-500' : 'text-indigo-100' }}">
                                        {{ $timestamp ?? '' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div
                            class="flex flex-col items-center justify-center h-full text-center text-gray-500 py-12">
                            <i class="ph ph-chat-circle-dots text-4xl mb-3"></i>
                            <p class="font-medium">Aucun message pour le moment</p>
                            <p class="text-sm">La conversation apparaîtra ici dès qu'un message sera envoyé.</p>
                        </div>
                    @endforelse
                </div>

                <div class="border-t bg-white p-4">
                    <form wire:submit.prevent="sendMessage" class="space-y-3">
                        <div>
                            <x-basics.textarea name="newMessage" 
                                placeholder="Écrire un message..." wire:model.live.debounce.1000ms="newMessage" rows="3"
                                mb="0" />
                            @error('newMessage')
                                <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="text-xs text-gray-500">
                            <div>
                                @if ($offlineMode)
                                    <span class="text-amber-600 flex items-center gap-1">
                                        <i class="ph ph-warning"></i>
                                        Vous êtes hors ligne. Impossible d'envoyer un message.
                                    </span>
                                @else
                                    <span class="flex items-center gap-1">
                                        <i class="ph ph-info"></i>
                                        Appuyez sur Entrée pour envoyer, Shift+Entrée pour une nouvelle ligne.
                                    </span>
                                @endif
                                @if ($successMessage)
                                    <span class="text-green-600 flex items-center gap-1 mt-1">
                                        <i class="ph ph-check-circle"></i>
                                        {{ $successMessage }}
                                    </span>
                                @endif
                            </div>

                            @if (!$offlineMode)
                            <x-basics.button class="w-full mt-3" type="submit" :disabled="$sending || trim($newMessage) === ''" wireTarget="sendMessage">
                                <span wire:loading.remove wire:target="sendMessage">
                                    <i class="ph ph-paper-plane-tilt mr-2"></i>
                                    Envoyer
                                </span>
                                <span wire:loading wire:target="sendMessage">
                                    Envoi...
                                </span>
                            </x-basics.button>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="space-y-4">           

            <x-basics.card title="Résumé" subtitle="Activité de la conversation">
                <div class="space-y-3 text-sm text-gray-700">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-500">Messages</span>
                        <span class="font-semibold">{{ count($messages) }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-500">Créée</span>
                        <span class="font-semibold">
                            {{ isset($conversation['conversation']['created_at']) ? \Carbon\Carbon::parse($conversation['conversation']['created_at'])->format('d/m/Y H:i') : '—' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-500">Dernière activité</span>
                        <span class="font-semibold">
                            {{ isset($conversation['conversation']['updated_at']) ? \Carbon\Carbon::parse($conversation['conversation']['updated_at'])->format('d/m/Y H:i') : '—' }}
                        </span>
                    </div>
                    <div class="flex items-center gap-2 text-sm text-gray-500">
                        <i class="ph ph-info"></i>
                        Les messages seront conserver dans votre historique jusqu'à 3 mois et seront supprimés automatiquement.
                    </div>
                </div>
            </x-basics.card>

        </div>
    </div>
    @else
        <div class="mt-6 bg-white border border-gray-300 rounded shadow">
            <div class="p-8 text-center text-gray-500">
                <i class="ph ph-chat-circle-dots text-4xl mb-3"></i>
                <p class="text-lg font-medium">Conversation introuvable</p>
                <p class="text-sm">Impossible d'afficher cette conversation pour le moment.</p>
            </div>
        </div>
    @endif
</div>
