<div class="container mx-auto space-y-6">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Catégories' => route('categories.index'),
        $category->name => null,
    ]">
        <x-slot name="action">
           <x-dashboard.categories.dropdown :category="$category" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">

        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">

            <!-- Category Information -->
            <x-basics.card title="Informations de la catégorie" subtitle="Détails de la catégorie">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Category Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-tag text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom de la catégorie</h3>
                                <p class="text-sm text-gray-600">{{ $category->name }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Products Count -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-package text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nombre de produits</h3>
                                <p class="text-sm text-gray-600">{{ $category->products_count ?? 0 }} produits</p>
                            </div>
                        </div>
                    </div>

                    <!-- Created Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Créée le</h3>
                                <p class="text-sm text-gray-600">{{ $category->created_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Updated Date -->
                    @if ($category->updated_at != $category->created_at)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-clock text-orange-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Modifiée le</h3>
                                    <p class="text-sm text-gray-600">{{ $category->updated_at->format('d/m/Y H:i') }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                @if ($category->description)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Description</h3>
                                <p class="text-sm text-gray-600">{{ $category->description }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>

            <!-- Products in this Category -->
            <x-basics.card title="Produits de cette catégorie" subtitle="Liste des produits associés">
                @if ($category->products && $category->products->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Produit</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Prix de vente</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Stock</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($category->products as $product)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2">{{ $loop->iteration }}.</td>
                                        <td class="px-3 py-2">
                                            <a href="{{ route('products.show', $product) }}"
                                                class="text-sm font-medium text-blue-600 hover:text-blue-900">
                                                {{ $product->name }}
                                            </a>
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">
                                            {{ $product->selling_price ? number_format($product->selling_price, 2) . ' CDF' : '—' }}
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">
                                            {!! $product->getStockStatusBadge() !!}
                                        </td>
                                        <td class="px-3 py-2">
                                            {!! $product->getStatusBadge() !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-8">
                        <div class="text-gray-500">
                            <i class="ph ph-package text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucun produit dans cette catégorie</p>
                            <p class="text-sm">Les produits ajoutés à cette catégorie apparaîtront ici</p>
                        </div>
                    </div>
                @endif
            </x-basics.card>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.categories.sidebar :category="$category" />
        </div>
    </div>
</div>