<div class="container mx-auto" x-data="{ showCreateCategoryModal: false }">

    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Inventaire' => route('products.index'),
        'Catégories' => null,
    ]">
        <x-slot name="action">
            <x-basics.button @click="showCreateCategoryModal = true">
                <i class="ph ph-plus mr-2"></i>
                Ajouter une catégorie
            </x-basics.button>
        </x-slot>
    </x-dashboard.breadcrumb>

    <!-- Search Section -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form action="{{ route('categories.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <x-basics.input name="search" label="Rechercher..." placeholder="Nom de la catégorie..."
                    value="{{ request('search') }}" mb="mb-0" />
            </div>
            <div class="flex gap-2">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Rechercher
                </x-basics.button>
                @if (request('search'))
                    <x-basics.button-link href="{{ route('categories.index') }}" variant="outline">
                        <i class="ph ph-arrow-clockwise mr-2"></i>
                        Reset
                    </x-basics.button-link>
                @endif
            </div>
        </form>
    </div>

    <!-- Categories Table -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Liste des catégories</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($categories && $categories->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Catégorie</th>
                            <th class="p-3 text-left font-medium text-gray-700">Description</th>
                            <th class="p-3 text-left font-medium text-gray-700 w-10 text-end">Produits</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($categories as $category)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration }}.
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link size=""
                                        href="{{ route('categories.show', $category) }}">{{ $category->name }}</x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    @if ($category->description)
                                        {{ Str::limit($category->description, 80) }}
                                    @else
                                        <span class="text-gray-400">Aucune description</span>
                                    @endif
                                </td>
                                <td class="px-3 py-2 text-end">
                                    {{ $category->products_count ?? 0 }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-tag text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucune catégorie trouvée</p>
                        <p class="text-sm">Commencez par créer votre première catégorie</p>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Pagination -->
    @if ($categories->hasPages())
        <div class="mt-6">
            {{ $categories->links() }}
        </div>
    @endif

    {{-- MODALS --}}
    <!-- Create Category Modal -->
    <form action="{{ route('categories.store') }}" method="POST">
        @csrf
        <x-basics.modal show="showCreateCategoryModal" title="Créer une catégorie"
            description="Configurez votre catégorie">

            <x-basics.input name="name" label="Nom" placeholder="Ex. Antibiotiques" :error="$errors->first('name')" required />

            @slot('footer')
                <div class="flex justify-end">
                    <x-basics.button type="submit" class="w-full">
                        Ajouter la catégorie
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>

</div>
