<div class="flex flex-col md:flex-row md:h-screen">
    @include('components.basics.toast')

    <!-- Left Column - Form (Scrollable) -->
    <div class="w-full md:w-1/3 md:overflow-y-auto flex items-center justify-center px-4 py-8 md:px-8 relative min-h-screen">
        <div class="w-full max-w-md px-8">
            <x-basics.section-title title="Réinitialiser le mot de passe" Subtitle="Entrez votre numéro de téléphone pour recevoir un lien de réinitialisation." />

            @if ($success)
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                    <div class="flex items-center">
                        <i class="ph ph-check-circle mr-2"></i>
                        Un lien de réinitialisation a été envoyé à votre numéro de téléphone.
                    </div>
                </div>
            @else
                <form wire:submit.prevent="sendResetLink" class="space-y-6 mt-6">
                    @csrf
                    
                    @if ($error_message)
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                            <div class="flex items-center">
                                <i class="ph ph-warning-circle mr-2"></i>
                                {{ $error_message }}
                            </div>
                        </div>
                    @endif

                    <div class="mb-4">
                        <x-basics.input type="tel" name="phone" label="Numéro de téléphone"
                            placeholder="Numéro de téléphone (+243)" wire:model.live.debounce.1000ms="phone"
                            :error="$errors->first('phone')" />
                    </div>

                    <x-basics.button :disabled="$loading" type="submit" class="w-full" wireTarget="sendResetLink">
                        <span wire:loading.remove wire:target="sendResetLink">Envoyer le lien de réinitialisation</span>
                        <span wire:loading wire:target="sendResetLink">Envoi en cours...</span>
                    </x-basics.button>

                    <div class="text-center">
                        <x-auth.logout-link />
                    </div>
                </form>
            @endif
        </div>

        <footer class="absolute bottom-0 left-0 right-0">
            <div class="flex justify-center items-center">
                <p class="text-sm text-gray-500">Copyright © 2025 Ango. Tous droits réservés.</p>
            </div>
        </footer>
    </div>

    <!-- Right Column - Background Image (Hidden on mobile, Sticky on desktop) -->
    <div class="hidden md:flex md:sticky md:top-0 md:w-2/3 md:h-screen items-center justify-center">
        <div class="w-full h-full bg-cover bg-center bg-no-repeat bg-black/70" style="background-image: url('{{ asset('images/bg-login.png') }}');">
        </div>
    </div>
</div>

<script>
document.addEventListener('livewire:init', () => {
    Livewire.on('redirect-to-login', () => {
        setTimeout(() => {
            window.location.href = '{{ route("login") }}';
        }, 3000);
    });
});
</script>