<x-layouts.dashboard>
    <div class="container mx-auto max-w-4xl">
        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Politique de confidentialité' => null,
        ]" />

        <div class="mt-6">
            <x-basics.card title="Politique de confidentialité" subtitle="Dernière mise à jour: {{ date('d/m/Y') }}">
                <div class="prose prose-gray max-w-none">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">1. Introduction</h3>
                    <p class="text-gray-700 mb-6">
                        Cette politique de confidentialité décrit comment Ango collecte, utilise et protège 
                        vos informations personnelles lorsque vous utilisez notre application de gestion pharmaceutique.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">2. Informations collectées</h3>
                    <div class="text-gray-700 mb-6">
                        <p class="mb-3">Nous collectons les types d'informations suivants :</p>
                        <ul class="list-disc pl-6 space-y-2">
                            <li><strong>Informations d'établissement :</strong> Nom, adresse, téléphone, email, type d'établissement</li>
                            <li><strong>Données commerciales :</strong> Informations sur les ventes, stocks, clients</li>
                            <li><strong>Données de connexion :</strong> Identifiants, adresse IP, horaires de connexion</li>
                            <li><strong>Données techniques :</strong> Informations sur l'appareil et l'utilisation de l'application</li>
                        </ul>
                    </div>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">3. Utilisation des informations</h3>
                    <div class="text-gray-700 mb-6">
                        <p class="mb-3">Nous utilisons vos informations pour :</p>
                        <ul class="list-disc pl-6 space-y-2">
                            <li>Fournir et améliorer nos services</li>
                            <li>Gérer votre compte et établissement</li>
                            <li>Assurer la sécurité de l'application</li>
                            <li>Respecter les obligations légales</li>
                            <li>Communiquer avec vous concernant le service</li>
                        </ul>
                    </div>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">4. Partage des informations</h3>
                    <p class="text-gray-700 mb-6">
                        Nous ne vendons, ne louons ni ne partageons vos informations personnelles avec des tiers, 
                        sauf dans les cas suivants :
                    </p>
                    <ul class="list-disc pl-6 space-y-2 text-gray-700 mb-6">
                        <li>Avec votre consentement explicite</li>
                        <li>Pour respecter une obligation légale</li>
                        <li>Pour protéger nos droits et la sécurité de l'application</li>
                        <li>Avec des prestataires de services tiers sous contrat de confidentialité</li>
                    </ul>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">5. Sécurité des données</h3>
                    <p class="text-gray-700 mb-6">
                        Nous mettons en place des mesures de sécurité appropriées pour protéger vos informations 
                        contre l'accès non autorisé, la modification, la divulgation ou la destruction. 
                        Cela inclut le chiffrement des données sensibles et l'accès restreint aux informations.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">6. Conservation des données</h3>
                    <p class="text-gray-700 mb-6">
                        Nous conservons vos informations aussi longtemps que nécessaire pour fournir nos services 
                        et respecter nos obligations légales. Les données peuvent être conservées plus longtemps 
                        si requis par la loi ou pour des raisons de sécurité.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">7. Vos droits</h3>
                    <div class="text-gray-700 mb-6">
                        <p class="mb-3">Vous avez le droit de :</p>
                        <ul class="list-disc pl-6 space-y-2">
                            <li>Accéder à vos informations personnelles</li>
                            <li>Corriger les informations inexactes</li>
                            <li>Demander la suppression de vos données</li>
                            <li>Limiter le traitement de vos données</li>
                            <li>Vous opposer au traitement de vos données</li>
                            <li>Demander la portabilité de vos données</li>
                        </ul>
                    </div>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">8. Cookies et technologies similaires</h3>
                    <p class="text-gray-700 mb-6">
                        L'application utilise des cookies et technologies similaires pour améliorer votre expérience 
                        utilisateur, analyser l'utilisation et personnaliser le contenu. Vous pouvez contrôler 
                        ces technologies via les paramètres de votre navigateur.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">9. Modifications de la politique</h3>
                    <p class="text-gray-700 mb-6">
                        Nous pouvons modifier cette politique de confidentialité occasionnellement. 
                        Nous vous informerons de tout changement important par notification dans l'application 
                        ou par email.
                    </p>

                    <h3 class="text-lg font-semibold text-gray-900 mb-4">10. Contact</h3>
                    <p class="text-gray-700 mb-6">
                        Pour toute question concernant cette politique de confidentialité ou pour exercer vos droits, 
                        veuillez nous contacter via les canaux de support de l'application.
                    </p>

                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mt-6">
                        <h4 class="font-semibold text-blue-900 mb-2">Conformité réglementaire</h4>
                        <p class="text-blue-800 text-sm">
                            Cette politique est conforme aux réglementations locales et internationales sur la protection 
                            des données, notamment la loi congolaise sur la protection des données personnelles.
                        </p>
                    </div>
                </div>

                <x-slot name="footer">
                    <div class="flex justify-between items-center">
                        <x-basics.link href="{{ route('terms') }}" variant="secondary">
                            <i class="ph ph-arrow-left mr-2"></i>
                            Conditions d'utilisation
                        </x-basics.link>
                        <x-basics.link href="{{ route('home') }}" variant="primary">
                            Retour au tableau de bord
                            <i class="ph ph-arrow-right ml-2"></i>
                        </x-basics.link>
                    </div>
                </x-slot>
            </x-basics.card>
        </div>
    </div>
</x-layouts.dashboard>
