<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Phosphor Icons -->
    <link rel="stylesheet" type="text/css" href="{{ asset('plugins/phosphor-icons/regular/style.css') }}" />
    <link rel="stylesheet" type="text/css" href="{{ asset('plugins/phosphor-icons/fill/style.css') }}" />
    @livewireStyles
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    {{-- <link rel="stylesheet" href="{{ asset('build/assets/app-BV7Thv1u.css') }}">
    <script src="{{ asset('build/assets/app-DsaENKCq.js') }}"></script> --}}
</head>


<body class="bg-[#FCFCFC]">
    <!-- Content -->
    <div>
        <x-partials.navigation />
        @include('components.basics.toast')
        <livewire:utils.is-online />
        <div class="min-h-screen bg-gray-50 text-gray-900">
            <div class="flex min-h-screen">
                <!-- Sidebar -->
                @php
                    $current = isset($current) ? $current : 'dashboard';
                @endphp
                <x-partials.sidebar :current="$current" />
                <!-- Main Content -->
                <main class="flex-1 bg-gray-100 min-h-screen px-6 py-22">
                    {{ $slot }}
                </main>
            </div>
        </div>
    </div>
    @stack('scripts')
    @livewireScripts
    <script>
        setInterval(() => {
            fetch('https://clients3.google.com/generate_204', {
                    mode: 'no-cors'
                })
                .then(() => Livewire.dispatch('connection-status', {
                    online: true
                }))
                .catch(() => Livewire.dispatch('connection-status', {
                    online: false
                }));
        }, 10000);
    </script>
</body>
</html>
