<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Mon compte' => route('account.index'),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <div class="flex items-center gap-2">                
                <x-dashboard.account.dropdown :user="$user" />
            </div>
        </x-slot>
    </x-dashboard.breadcrumb>

    @include('components.basics.toast')

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">

        <!-- Main Content -->
        <div class="w-full lg:w-8/12">
            <form wire:submit.prevent="save">
                <x-basics.card title="Informations de l'utilisateur" subtitle="Mettre à jour vos informations">
                    <x-slot name="action">
                        <x-basics.flash :model="'success'" :timeout="3000"/>
                        <x-basics.flash :model="'error'" :message="$errorMessage" :timeout="3000"/>
                    </x-slot>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <x-basics.input name="firstname" label="Prénom" wire:model.live.debounce.1000ms="firstname" :error="$errors->first('firstname')"
                                class="mb-4" />
                        </div>
                        <div>
                            <x-basics.input name="lastname" label="Nom" wire:model.live.debounce.1000ms="lastname" :error="$errors->first('lastname')"
                                class="mb-4" />
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <x-basics.input name="email" label="Email" wire:model.live.debounce.1000ms="email" :error="$errors->first('email')"
                                class="mb-4" disabled="true" readonly="true" />
                        </div>

                        <div>
                            <x-basics.input name="phone" label="Téléphone" wire:model.live.debounce.1000ms="phone" :error="$errors->first('phone')"
                                class="mb-4" />
                        </div>
                    </div>


                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <x-basics.input name="username" label="Nom d'utilisateur" wire:model="username"
                            disabled="true" class="mb-4" />
                        </div>
                    </div>




                    <x-slot name="footer">
                        <x-basics.button type="submit" class="w-full" :disabled="!$can_save || $loading" leftIcon="floppy-disk" wire:target="save">
                            @if($loading)
                                Enregistrement...
                            @else
                                Enregistrer les modifications
                            @endif
                        </x-basics.button>
                    </x-slot>

                </x-basics.card>
            </form>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.account.sidebar :user="$user" />
        </div>

    </div>
</div>
