@props([
    'current' => 'dashboard',
])


@php
    $currentUserRole = auth()->user()?->role;
    $pendingPrescriptionsCount = getEnAttentePrescriptionsCount();


    if(settings('merchant_status') == \App\Models\Merchant::STATUS_ACTIVE){
        $links = [
            [
                'name' => 'Tableau de bord',
                'url' => '/',
                'icon' => 'ph ph-house',
                'slug' => 'dashboard',
                'badge' => '',
                'roles' => ['owner', 'admin', 'cashier', 'stock_manager'],
            ],
            [
                'name' => 'Ventes',
                'url' => '',
                'icon' => 'ph ph-money',
                'slug' => 'sales',
                'badge' => '',
                'roles' => ['owner', 'admin', 'cashier'],
                'children' => [
                    [
                        'name' => 'Nouvelle Vente',
                        'url' => 'sales/create',
                        'icon' => 'ph ph-plus',
                        'slug' => 'sales-create',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'cashier'],
                    ],
                    [
                        'name' => 'Liste des Ventes',
                        'url' => 'sales',
                        'icon' => 'ph ph-list',
                        'slug' => 'sales-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'cashier'],
                    ],
                    [
                        'name' => 'Clients',
                        'url' => 'customers',
                        'icon' => 'ph ph-users',
                        'slug' => 'sales-customers',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'cashier'],
                    ],
                ],
            ],
            [
                'name' => 'Dépenses',
                'url' => '',
                'icon' => 'ph ph-receipt',
                'slug' => 'expenses',
                'badge' => '',
                'roles' => ['owner', 'admin'],
                'children' => [
                    [
                        'name' => 'Liste des Dépenses',
                        'url' => 'expenses',
                        'icon' => 'ph ph-list',
                        'slug' => 'expenses-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Catégories',
                        'url' => 'expense-categories',
                        'icon' => 'ph ph-folders',
                        'slug' => 'expense-categories-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                ],
            ],

            [
                'name' => 'Gestion des dettes',
                'url' => 'debts',
                'icon' => 'ph ph-credit-card',
                'slug' => 'debts-index',
                'badge' => '',
                'roles' => ['owner', 'admin', 'cashier'],
            ],
            [
                'name' => 'Prescriptions',
                'url' => '',
                'icon' => 'ph ph-prescription',
                'slug' => 'prescriptions-index',
                'badge' => $pendingPrescriptionsCount,
                'roles' => ['owner', 'admin', 'cashier'],
                'children' => [
                    [
                        'name' => 'Liste',
                        'url' => 'prescriptions',
                        'icon' => 'ph ph-prescription',
                        'slug' => 'prescriptions-index',
                        'badge' => $pendingPrescriptionsCount,
                        'roles' => ['owner', 'admin', 'cashier'],
                    ],
                    [
                        'name' => 'Conversations',
                        'url' => 'conversations',
                        'icon' => 'ph ph-chat-circle',
                        'slug' => 'conversations-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'cashier'],
                    ],
                ],
            ],
            [
                'name' => 'Stock',
                'url' => 'products',
                'icon' => 'ph ph-package',
                'slug' => 'products-index',
                'badge' => '',
                'roles' => ['cashier', 'stock_manager'],
            ],
            [
                'name' => 'Inventaire',
                'url' => '',
                'icon' => 'ph ph-package',
                'slug' => 'products',
                'badge' => '',
                'roles' => ['owner', 'admin', 'stock_manager'],
                'children' => [
                    [
                        'name' => 'Produits',
                        'url' => 'products',
                        'icon' => 'ph ph-archive',
                        'slug' => 'products-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'stock_manager'],
                    ],
                    [
                        'name' => 'Bons de commande',
                        'url' => 'purchase-orders',
                        'icon' => 'ph ph-bag',
                        'slug' => 'purchase-orders-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'stock_manager'],
                    ],
                    [
                        'name' => 'Réceptions de produits',
                        'url' => 'stock-entries',
                        'icon' => 'ph ph-tag-simple',
                        'slug' => 'stock-entries-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'stock_manager'],
                    ],
                    [
                        'name' => 'Ajustements de stock',
                        'url' => 'stock-adjustments',
                        'icon' => 'ph ph-trolley',
                        'slug' => 'stock-adjustments-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'stock_manager'],
                    ],
                    [
                        'name' => 'Fournisseurs',
                        'url' => 'suppliers',
                        'icon' => 'ph ph-users',
                        'slug' => 'suppliers-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'stock_manager'],
                    ],
                    [
                        'name' => 'Catégories',
                        'url' => 'categories',
                        'icon' => 'ph ph-tag',
                        'slug' => 'categories-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'stock_manager'],
                    ],
                    [
                        'name' => 'Unités de mesure',
                        'url' => 'units',
                        'icon' => 'ph ph-scales',
                        'slug' => 'units-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin', 'stock_manager'],
                    ],
                ],
            ],
            [
                'name' => 'Rapports & Analytique',
                'url' => 'reports',
                'icon' => 'ph ph-chart-line',
                'slug' => 'reports-index',
                'badge' => '',
                'roles' => ['owner', 'admin'],
                'children' => [
                    [
                        'name' => 'Rapport de Stock',
                        'url' => 'reports/stock-report',
                        'icon' => 'ph ph-package',
                        'slug' => 'reports-stock-report',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Performance des Ventes',
                        'url' => 'reports/sales-performance',
                        'icon' => 'ph ph-chart-line',
                        'slug' => 'reports-sales-performance',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Intelligence d\'Inventaire',
                        'url' => 'reports/inventory-intelligence',
                        'icon' => 'ph ph-package',
                        'slug' => 'reports-inventory-intelligence',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Vue d\'Ensemble BI',
                        'url' => 'reports/business-intelligence',
                        'icon' => 'ph ph-chart-line-up',
                        'slug' => 'reports-business-intelligence',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                ],
            ],
            [
                'name' => 'Paramètres',
                'url' => '',
                'icon' => 'ph ph-gear',
                'slug' => 'settings',
                'badge' => '',
                'roles' => ['owner', 'admin'],
                'children' => [
                    [
                        'name' => 'Etablissement',
                        'url' => 'merchant',
                        'icon' => 'ph ph-building',
                        'slug' => 'merchant',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Méthodes de paiement',
                        'url' => 'payment-methods',
                        'icon' => 'ph ph-credit-card',
                        'slug' => 'payment-methods-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Types de vente',
                        'url' => 'sale-types',
                        'icon' => 'ph ph-tag',
                        'slug' => 'sale-types-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Utilisateurs',
                        'url' => 'users',
                        'icon' => 'ph ph-users',
                        'slug' => 'users-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Abonnements',
                        'url' => 'subscriptions',
                        'icon' => 'ph ph-credit-card',
                        'slug' => 'subscriptions-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                ],
            ],
            [
                'name' => 'Mon compte',
                'url' => 'account',
                'icon' => 'ph ph-user',
                'slug' => 'account',
                'badge' => '',
                'roles' => ['owner', 'admin', 'cashier', 'stock_manager'],
            ],
        ];
    } elseif (settings('merchant_status') == \App\Models\Merchant::STATUS_DRAFT || settings('merchant_status') == \App\Models\Merchant::STATUS_SUSPENDED) {
        $links = [
            [
                'name' => 'Tableau de bord',
                'url' => '/',
                'icon' => 'ph ph-house',
                'slug' => 'dashboard',
                'badge' => '',
                'roles' => ['owner', 'admin', 'cashier', 'stock_manager'],
            ],
            [
                'name' => 'Paramètres',
                'url' => '',
                'icon' => 'ph ph-gear',
                'slug' => 'settings',
                'badge' => '',
                'roles' => ['owner', 'admin'],
                'children' => [
                    [
                        'name' => 'Etablissement',
                        'url' => 'merchant',
                        'icon' => 'ph ph-building',
                        'slug' => 'merchant',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Utilisateurs',
                        'url' => 'users',
                        'icon' => 'ph ph-users',
                        'slug' => 'users-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                    [
                        'name' => 'Abonnements',
                        'url' => 'subscriptions',
                        'icon' => 'ph ph-credit-card',
                        'slug' => 'subscriptions-index',
                        'badge' => '',
                        'roles' => ['owner', 'admin'],
                    ],
                ],
            ],
            [
                'name' => 'Mon compte',
                'url' => 'account',
                'icon' => 'ph ph-user',
                'slug' => 'account',
                'badge' => '',
                'roles' => ['owner', 'admin', 'cashier', 'stock_manager'],
            ],
        ];
    }
@endphp

@php
    $currentPath = trim(request()->path(), '/');
@endphp

<div x-data="{ open: true, drawer: false }" x-init="
    // Close drawer on Livewire navigation
    window.addEventListener('livewire:navigated', () => { drawer = false; document.body.classList.remove('overflow-hidden') });
    // Prevent body scroll when drawer is open
    $watch('drawer', value => { if (value) { document.body.classList.add('overflow-hidden') } else { document.body.classList.remove('overflow-hidden') } })
">

    <!-- Mobile Toggle Button -->
    <button
        class="lg:hidden fixed top-4 left-4 z-30 bg-gray-900 text-white p-2 rounded shadow"
        @click="drawer = true"
        aria-label="Open sidebar"
    >
        <i class="ph ph-list text-xl"></i>
    </button>

    <aside
        class="hidden lg:block bg-gray-900 text-white pb-5 transition-all duration-300 ease-in-out z-20 sticky top-0 h-screen"
        :class="open ? 'w-64' : 'w-16'"
    >
    <!-- Brand & Toggle -->
    <div class="flex items-center justify-between p-4">
        <a href="{{ route('home') }}">
            <img src="{{ asset('images/logo.png') }}" alt="Logo"  style="height: 64px;">
        </a>
    </div>

    <!-- Navigation -->
    <nav class="px-2 space-y-2 max-h-[calc(100vh-64px)] overflow-y-auto scrollbar-hide">
        <style>
            .scrollbar-hide {
                -ms-overflow-style: none;
                scrollbar-width: none;
            }

            .scrollbar-hide::-webkit-scrollbar {
                display: none;
            }
        </style>

        @foreach ($links as $link)
            @php
                if (isset($link['roles']) && $currentUserRole && !in_array($currentUserRole, $link['roles'])) {
                    continue;
                }
            @endphp
            @php
                $hasChildren = !empty($link['children']);
                // Determine active state based on current URL path
                $isActiveParent = false;
                if ($hasChildren) {
                    $isActiveParent = collect($link['children'])->contains(function ($child) {
                        $pattern = trim($child['url'], '/');
                        return $pattern === '' ? request()->is('/') : request()->is($pattern.'*');
                    });
                }
            @endphp

            @if ($hasChildren)
                <div x-data="{ openChild: {{ $isActiveParent ? 'true' : 'false' }} }" class="flex flex-col">
                    <!-- Parent Toggle -->
                    <button @click="openChild = !openChild"
                        class="flex items-center w-full p-2 text-sm rounded hover:bg-gray-700 transition-all duration-150"
                        :class="{ 'bg-gray-800': {{ $isActiveParent ? 'true' : 'false' }} }">
                        <i class="{{ $link['icon'] }} mr-3 text-lg"></i>
                        <span x-show="open" class="flex-1 text-left truncate">{{ $link['name'] }}</span>
                        @if ($link['badge'])
                            <span x-show="open"
                                class="ml-2 text-xs font-semibold bg-red-500 text-white px-2 py-0.5 rounded-full">{{ $link['badge'] }}</span>
                        @endif
                        <svg x-show="open" :class="{ 'transform rotate-90': openChild }"
                            class="h-4 w-4 text-gray-400 transition-transform duration-200 ml-2" fill="none"
                            stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round"
                            stroke-linejoin="round">
                            <path d="M9 5l7 7-7 7"></path>
                        </svg>
                    </button>

                    <!-- Child Links -->
                    <div x-show="openChild" x-cloak class="flex flex-col ml-8 mt-1 space-y-1">
                        @foreach ($link['children'] as $child)
                            @php
                                if (isset($child['roles']) && $currentUserRole && !in_array($currentUserRole, $child['roles'])) {
                                    continue;
                                }
                            @endphp
                            @php 
                                $childPattern = trim($child['url'], '/');
                                $isActive = $childPattern === '' ? request()->is('/') : request()->is($childPattern.'*');
                            @endphp
                            <a href="{{ url($child['url']) }}" wire:navigate
                                class="flex items-center p-2 text-sm rounded hover:bg-gray-700 transition-all duration-150 {{ $isActive ? 'bg-gray-800' : '' }}">
                                <i class="{{ $child['icon'] }} mr-3 text-base"></i>
                                <span x-show="open" class="flex-1 truncate">{{ $child['name'] }}</span>
                                @if ($child['badge'])
                                    <span x-show="open"
                                        class="ml-2 text-xs font-semibold bg-red-500 text-white px-2 py-0.5 rounded-full">{{ $child['badge'] }}</span>
                                @endif
                            </a>
                        @endforeach
                    </div>
                </div>
            @else
                <!-- Single Link -->
                @php 
                    $pattern = trim($link['url'], '/');
                    $isActive = $pattern === '' ? request()->is('/') : request()->is($pattern.'*');
                @endphp
                <a href="{{ url($link['url']) }}" wire:navigate
                    class="flex items-center p-2 text-sm rounded hover:bg-gray-700 transition-all duration-150 {{ $isActive ? 'bg-gray-800' : '' }}">
                    <i class="{{ $link['icon'] }} mr-3 text-lg"></i>
                    <span x-show="open" class="flex-1 truncate">{{ $link['name'] }}</span>
                    @if ($link['badge'])
                        <span x-show="open"
                            class="ml-2 text-xs font-semibold bg-red-500 text-white px-2 py-0.5 rounded-full">{{ $link['badge'] }}</span>
                    @endif
                </a>
            @endif
        @endforeach
    </nav>
    </aside>

    <!-- Mobile Overlay -->
    <div
        class="fixed inset-0 bg-black/40 z-40 lg:hidden"
        x-show="drawer"
        x-transition.opacity
        @click="drawer = false"
    ></div>

    <!-- Mobile Drawer Sidebar -->
    <aside
        class="lg:hidden fixed inset-y-0 left-0 bg-gray-900 text-white w-64 pb-5 z-50 transform transition-transform duration-300 ease-in-out"
        :class="drawer ? 'translate-x-0' : '-translate-x-full'"
        x-show="drawer"
        x-transition
    >
        <div class="flex items-center justify-between p-4">
            <a href="{{ route('home') }}">
                <img src="{{ asset('images/logo.png') }}" alt="Logo"  style="height: 48px;">
            </a>
            <button class="text-gray-300 hover:text-white" @click="drawer = false" aria-label="Close sidebar">
                <i class="ph ph-x text-xl"></i>
            </button>
        </div>

        <!-- Duplicate nav for mobile -->
        <nav class="px-2 space-y-2 max-h-[calc(100vh-64px)] overflow-y-auto scrollbar-hide">
            <style>
                .scrollbar-hide { -ms-overflow-style: none; scrollbar-width: none; }
                .scrollbar-hide::-webkit-scrollbar { display: none; }
            </style>
            @foreach ($links as $link)
                @php
                    if (isset($link['roles']) && $currentUserRole && !in_array($currentUserRole, $link['roles'])) {
                        continue;
                    }
                @endphp
                @php
                    $hasChildren = !empty($link['children']);
                    $isActiveParent = false;
                    if ($hasChildren) {
                        $isActiveParent = collect($link['children'])->contains(function ($child) {
                            $pattern = trim($child['url'], '/');
                            return $pattern === '' ? request()->is('/') : request()->is($pattern.'*');
                        });
                    }
                @endphp

                @if ($hasChildren)
                    <div x-data="{ openChild: {{ $isActiveParent ? 'true' : 'false' }} }" class="flex flex-col">
                        <button @click="openChild = !openChild"
                            class="flex items-center w-full p-2 text-sm rounded hover:bg-gray-700 transition-all duration-150"
                            :class="{ 'bg-gray-800': {{ $isActiveParent ? 'true' : 'false' }} }">
                            <i class="{{ $link['icon'] }} mr-3 text-lg"></i>
                            <span class="flex-1 text-left truncate">{{ $link['name'] }}</span>
                            @if ($link['badge'])
                                <span class="ml-2 text-xs font-semibold bg-red-500 text-white px-2 py-0.5 rounded-full">{{ $link['badge'] }}</span>
                            @endif
                            <svg :class="{ 'transform rotate-90': openChild }" class="h-4 w-4 text-gray-400 transition-transform duration-200 ml-2" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M9 5l7 7-7 7"></path>
                            </svg>
                        </button>
                        <div x-show="openChild" x-cloak class="flex flex-col ml-8 mt-1 space-y-1">
                            @foreach ($link['children'] as $child)
                            @php
                                if (isset($child['roles']) && $currentUserRole && !in_array($currentUserRole, $child['roles'])) {
                                    continue;
                                }
                            @endphp
                            @php 
                                $childPattern = trim($child['url'], '/');
                                $isActive = $childPattern === '' ? request()->is('/') : request()->is($childPattern.'*');
                            @endphp
                            <a href="{{ url($child['url']) }}" wire:navigate class="flex items-center p-2 text-sm rounded hover:bg-gray-700 transition-all duration-150 {{ $isActive ? 'bg-gray-800' : '' }}">
                                    <i class="{{ $child['icon'] }} mr-3 text-base"></i>
                                    <span class="flex-1 truncate">{{ $child['name'] }}</span>
                                    @if ($child['badge'])
                                        <span class="ml-2 text-xs font-semibold bg-red-500 text-white px-2 py-0.5 rounded-full">{{ $child['badge'] }}</span>
                                    @endif
                                </a>
                            @endforeach
                        </div>
                    </div>
                @else
                    @php 
                        $pattern = trim($link['url'], '/');
                        $isActive = $pattern === '' ? request()->is('/') : request()->is($pattern.'*');
                    @endphp
                    <a href="{{ url($link['url']) }}" wire:navigate class="flex items-center p-2 text-sm rounded hover:bg-gray-700 transition-all duration-150 {{ $isActive ? 'bg-gray-800' : '' }}">
                        <i class="{{ $link['icon'] }} mr-3 text-lg"></i>
                        <span class="flex-1 truncate">{{ $link['name'] }}</span>
                        @if ($link['badge'])
                            <span class="ml-2 text-xs font-semibold bg-red-500 text-white px-2 py-0.5 rounded-full">{{ $link['badge'] }}</span>
                        @endif
                    </a>
                @endif
            @endforeach
        </nav>
    </aside>
</div>
