<!-- Top Navbar -->
@auth
<div class="fixed top-0 left-0 right-0 w-full flex items-center justify-end gap-6 p-4 bg-white shadow-md z-10">
    <!-- Notification Icon -->
    {{-- <button class="relative focus:outline-none">
        <x-icons.bell />
        <!-- Badge -->
        <span class="absolute top-0 right-0 inline-flex items-center justify-center w-4 h-4 text-xs text-white bg-red-600 rounded-full">3</span>
    </button> --}}
    
    <!-- User Dropdown -->
    <div class="relative" x-data="{ open: false }">
        <button x-on:click="open = !open" class="flex items-center gap-2 px-4 py-2 font-semibold text-gray-700 rounded hover:bg-gray-200">
            {{ Auth::user()->username }}
            <x-icons.caret-down />
        </button>

        <!-- Dropdown Menu -->
        <div x-show="open" x-on:click.away="open = false"
            class="absolute right-0 z-50 w-48 mt-2 bg-white border border-gray-200 rounded shadow-md">
            <a href="{{ route('account.index') }}"
                class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                Profil
            </a>
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                @method('POST')
                <button type="submit"
                    class="w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                    Déconnexion
                </button>
            </form>
        </div>
    </div>
</div>
@endauth
