@props(['unit'])

<div x-data="{ showDeleteModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye"
                href="{{ route('units.show', $unit) }}">
                Voir
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-pencil"
                href="{{ route('units.edit', $unit) }}">
                Modifier
            </x-basics.dropdown-item>
            
            @if(($unit->products?->count() ?? 0) === 0)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    @if(($unit->products?->count() ?? 0) === 0)  
        <!-- Delete Modal -->
        <x-basics.modal show="showDeleteModal" title="Supprimer l'unité" description="Confirmer la suppression de l'unité">
            <p>Voulez-vous vraiment supprimer cette unité ?</p>
            <p class="text-sm text-red-500 mt-2">Cette action est irréversible.</p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <form method="POST" action="{{ route('units.destroy', $unit) }}" class="inline w-full">
                        @csrf
                        @method('DELETE')
                        <x-basics.button type="submit" variant="danger" class="w-full">
                            <i class="ph ph-trash mr-2"></i>
                            Supprimer
                        </x-basics.button>
                    </form>
                </div>
            @endslot
        </x-basics.modal>
    @endif
</div>


