@props(['supplier'])

<div >

    <div class="space-y-6" x-data="{ showActivateModal: false, showDeactivateModal: false, showDeleteModal: false }">
        <x-basics.card title="Statut" subtitle="Statut général du fournisseur" class="mb-6">
            <div class="space-y-3">
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Statut général:</span>
                    {!! $supplier->getStatusBadge() !!}
                </div>

                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Commandes:</span>
                    <span class="text-sm font-medium">{{ $supplier->purchaseOrders?->count() ?? 0 }}</span>
                </div>

                @if ($supplier->last_order_at)
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Dernière commande:</span>
                        <span class="text-sm">{{ $supplier->last_order_at->format('d M Y') }}</span>
                    </div>
                @endif

                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Créé le:</span>
                    <span class="text-sm">{{ $supplier->created_at->format('d M Y') }}</span>
                </div>

                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Modifié le:</span>
                    <span class="text-sm">{{ $supplier->updated_at->format('d M Y') }}</span>
                </div>
            </div>
        </x-basics.card>


        <!-- Supplier Information -->
        <x-basics.card title="À propos des Fournisseurs" bodyBg="bg-blue-50">
            <div class="space-y-3 text-sm text-gray-700">
                <div class="flex items-start space-x-2">
                    <i class="ph ph-buildings text-blue-600 mt-0.5"></i>
                    <p class="text-gray-600">
                        <strong>Les fournisseurs</strong> sont les entreprises qui vous fournissent vos produits.
                    </p>
                </div>
                
                <div class="flex items-start space-x-2">
                    <i class="ph ph-receipt text-green-600 mt-0.5"></i>
                    <p class="text-gray-600">
                        <strong>Les bons de commande</strong> permettent de gérer vos achats et réceptions.
                    </p>
                </div>
                
                <div class="flex items-start space-x-2">
                    <i class="ph ph-phone text-purple-600 mt-0.5"></i>
                    <p class="text-gray-600">
                        <strong>Les coordonnées</strong> sont essentielles pour maintenir une communication efficace.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Supplier Management -->
        <x-basics.card title="Gestion des Fournisseurs" bodyBg="bg-green-50">
            <div class="space-y-3 text-sm text-gray-700">
                <div class="flex items-start space-x-2">
                    <i class="ph ph-user-plus text-green-600 mt-0.5"></i>
                    <p class="text-gray-600">
                        <strong>Coordonnées à jour :</strong> Gardez téléphone et email à jour pour faciliter les commandes.
                    </p>
                </div>
                
                <div class="flex items-start space-x-2">
                    <i class="ph ph-chart-line text-blue-600 mt-0.5"></i>
                    <p class="text-gray-600">
                        <strong>Historique des commandes :</strong> Consultez les commandes récentes avant d'en créer une nouvelle.
                    </p>
                </div>
                
                <div class="flex items-start space-x-2">
                    <i class="ph ph-shield-check text-purple-600 mt-0.5"></i>
                    <p class="text-gray-600">
                        <strong>Fiabilité :</strong> Surveillez les délais et la qualité pour ajuster le statut du fournisseur.
                    </p>
                </div>
            </div>
        </x-basics.card>

    </div>

</div>