@props(['supplier'])

<div x-data="{ showActivateModal: false, showDeactivateModal: false, showDeleteModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('suppliers.show', $supplier) }}">
                Voir
            </x-basics.dropdown-item>

            @if($supplier->status == \App\Models\Supplier::STATUS_INACTIVE)
            <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('suppliers.edit', $supplier) }}">
                Modifier
            </x-basics.dropdown-item>
            @endif

            @if($supplier->status == \App\Models\Supplier::STATUS_ACTIVE)
                <x-basics.dropdown-item icon="ph ph-pause-circle" variant="warning" @click="showDeactivateModal = true">
                    Désactiver
                </x-basics.dropdown-item>
            @else
                <x-basics.dropdown-item icon="ph ph-play-circle" variant="success" @click="showActivateModal = true">
                    Activer
                </x-basics.dropdown-item>
            @endif

            @if($supplier->status == \App\Models\Supplier::STATUS_ACTIVE)
            <x-basics.dropdown-separator />

            <x-basics.dropdown-item icon="ph ph-list" href="{{ route('purchase-orders.index') }}?supplier_id={{ $supplier->id }}">
                Bons de commande
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-plus" href="{{ route('purchase-orders.index') }}?supplier_id={{ $supplier->id }}">
                Nouvelle commande
            </x-basics.dropdown-item>
            @endif
            
            @if($supplier->status == \App\Models\Supplier::STATUS_INACTIVE && ($supplier->purchaseOrders?->count() > 0))
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    @if($supplier->status == \App\Models\Supplier::STATUS_INACTIVE)
    <!-- Activate Modal -->
    <form method="POST" action="{{ route('suppliers.activate', $supplier) }}">
        @csrf
        <x-basics.modal show="showActivateModal" title="Activer le fournisseur" description="Confirmer l'activation">
            <p>Voulez-vous vraiment activer ce fournisseur ?</p>
            
            <p class="text-sm text-gray-600 mt-2">
                Le fournisseur sera remis en statut "Actif" et pourra être utilisé pour les opérations de stock.
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <x-basics.button type="submit" variant="success" class="w-full">
                        <i class="ph ph-play-circle mr-2"></i>
                        Activer
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
    @endif

    @if($supplier->status == \App\Models\Supplier::STATUS_ACTIVE)
    <!-- Deactivate Modal -->
    <form method="POST" action="{{ route('suppliers.deactivate', $supplier) }}">
        @csrf
        <x-basics.modal show="showDeactivateModal" title="Désactiver le fournisseur" description="Confirmer la désactivation">
            <p>Voulez-vous vraiment désactiver ce fournisseur ?</p>
            <p class="text-sm text-gray-600 mt-2">
                Le fournisseur sera remis en statut "Inactif" et ne pourra plus être utilisé pour les opérations de stock.
            </p>
            @slot('footer')
                <div class="flex justify-end gap-3">
                    <x-basics.button type="submit" variant="warning" class="w-full">
                        <i class="ph ph-pause-circle mr-2"></i>
                        Désactiver
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
    @endif

    @if($supplier->status == \App\Models\Supplier::STATUS_INACTIVE && ($supplier->purchaseOrders?->count() > 0))
    <!-- Delete Modal -->
    <form method="POST" action="{{ route('suppliers.destroy', $supplier) }}">
        @csrf
        @method('DELETE')
        <x-basics.modal show="showDeleteModal" title="Supprimer le fournisseur" description="Confirmer la suppression">
            <p>Voulez-vous vraiment supprimer ce fournisseur ?</p>
            <p class="text-sm text-gray-600 mt-2">
                Le fournisseur sera supprimé et ne pourra plus être utilisé pour les opérations de stock.
            </p>
            <p class="text-sm text-red-600 mt-2">Cette action est irréversible.</p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        <i class="ph ph-trash mr-2"></i>
                        Supprimer
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
    @endif
</div>
