@props(['stats' => null, 'subscription' => null])

<div class="space-y-6">
    <x-basics.card title="Statut" subtitle="État de l'abonnement">
        <div class="space-y-3 text-sm">
            <div class="flex items-center justify-between">
                <span class="text-gray-600">Jours restants</span>
                <span class="font-medium text-gray-900">
                    @php
                        $days = $subscription?->end_date ? (int) round(now()->diffInDays($subscription->end_date, false)) : null;
                    @endphp
                    {{ is_null($days) ? '—' : ($days > 0 ? $days . ' jours' : 'Expiré') }}
                </span>
            </div>
            <div class="flex items-center justify-between">
                <span class="text-gray-600">Statut</span>
                <span class="font-medium">{!! $subscription?->status_badge ?? '—' !!}</span>
            </div>
        </div>
    </x-basics.card>

    <x-basics.card title="Conseils" subtitle="Bonnes pratiques">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start gap-2">
                <i class="ph ph-lightbulb text-yellow-600 mt-0.5"></i>
                <p>Gardez votre abonnement actif pour éviter les interruptions de service.</p>
            </div>
            <div class="flex items-start gap-2">
                <i class="ph ph-bell-ringing text-blue-600 mt-0.5"></i>
                <p>Renouvelez quelques jours avant l'expiration pour une transition fluide.</p>
            </div>
            <div class="flex items-start gap-2">
                <i class="ph ph-shield-check text-green-600 mt-0.5"></i>
                <p>Conservez vos codes d'activation en lieu sûr.</p>
            </div>
            <div class="flex items-start gap-2">
                <i class="ph ph-headset text-purple-600 mt-0.5"></i>
                <p>Contactez le support en cas de problème d'activation.</p>
            </div>
        </div>
    </x-basics.card>
</div>


