@props(['stockEntry'])

<div class="space-y-6" x-data="{ showCompleteModal: false, showCancelModal: false, showDeleteModal: false }">
    <!-- Status Card -->
    <x-basics.card title="Statut" subtitle="Statut de l'entrée de stock">
        <div class="space-y-3">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                {!! $stockEntry->getStatusBadge() !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Type de source:</span>
                <span class="text-sm font-medium">{!! $stockEntry->getSourceTypeBadge() !!}</span>
            </div>

            @if($stockEntry->source_reference)
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Référence source:</span>
                    <span class="text-sm font-medium">{{ $stockEntry->source_reference }}</span>
                </div>
            @endif

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Créé le:</span>
                <span class="text-sm">{{ $stockEntry->created_at->format('d M Y') }}</span>
            </div>

            @if($stockEntry->completed_at)
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Complété le:</span>
                    <span class="text-sm">{{ $stockEntry->completed_at->format('d M Y') }}</span>
                </div>
            @endif
        </div>
    </x-basics.card>

    <!-- indications -->
    <!-- Stock Entry Information -->
    <x-basics.card title="À propos des Entrées de Stock" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-info text-blue-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Les entrées de stock</strong> représentent l'ajout de produits dans votre inventaire.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-calendar text-orange-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Date d'expiration</strong> : Essentielle pour la gestion des produits périssables et la rotation des stocks.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-hash text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Numéro de lot</strong> : Permet de tracer l'origine et l'historique de chaque batch de produits.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-currency-circle-dollar text-purple-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Prix d'achat</strong> : Utilisé pour calculer les coûts et la rentabilité des ventes.
                </p>
            </div>
        </div>
    </x-basics.card>

</div>
