@props(['adjustment'])

<div class="space-y-6">

    <x-basics.card title="Statut" subtitle="Détails rapides">
        <div class="space-y-4">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                <span class="text-sm font-medium">{!! $adjustment->getStatusBadge() !!}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Référence:</span>
                <span class="text-sm font-medium">{{ $adjustment->reference }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Type:</span>
                <span class="text-sm font-medium">{{ $adjustment->getTypeName() }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Articles:</span>
                <span class="text-sm font-medium">{{ $adjustment->items?->count() ?? 0 }}</span>
            </div>

            @if ($adjustment->status == \App\Models\StockAdjustment::STATUS_APPLIED && $adjustment->applied_at)
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Date d'application:</span>
                    <span class="text-sm font-medium">{{ $adjustment->applied_at?->format('d/m/Y') }}</span>
                </div>
            @endif


        </div>
    </x-basics.card>

    <x-basics.card title="Conseils pratiques" bodyBg="bg-blue-50">
        <div class="space-y-2 text-sm text-gray-700">
            <p class="text-gray-600 text-justify">
                <strong>· Justification claire:</strong> Ajoutez une raison précise (ex. expiré, cassé, inventaire).
            </p>
            <p class="text-gray-600 text-justify">
                <strong>· Traçabilité:</strong> Appliquez l'ajustement uniquement après vérification pour conserver un historique fiable.
            </p>
            <p class="text-gray-600 text-justify">
                <strong>· Cohérence:</strong> Utilisez la diminution pour pertes/expiration et l'augmentation pour corrections positives.
            </p>
        </div>
    </x-basics.card>

</div>


