@props(['adjustment'])

<div x-data="{ showApplyModal: false, showDeleteModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye"
                href="{{ route('stock-adjustments.show', $adjustment) }}">
                Voir
            </x-basics.dropdown-item>

            @if ($adjustment->status == \App\Models\StockAdjustment::STATUS_DRAFT)
            <x-basics.dropdown-item icon="ph ph-pencil"
                href="{{ route('stock-adjustments.edit', $adjustment) }}">
                Modifier
            </x-basics.dropdown-item>
            @endif

            @if ($adjustment->status == \App\Models\StockAdjustment::STATUS_APPLIED)
                <x-basics.dropdown-item icon="ph ph-printer"
                    href="{{ route('stock-adjustments.print', $adjustment) }}" target="_blank">
                    Imprimer
                </x-basics.dropdown-item>
            @endif

            @if ($adjustment->status !== \App\Models\StockAdjustment::STATUS_APPLIED)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-check-circle" variant="success"
                    @click="showApplyModal = true">
                    Appliquer
                </x-basics.dropdown-item>
            @endif

            @if ($adjustment->status !== \App\Models\StockAdjustment::STATUS_APPLIED)
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger"
                    @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    @if ($adjustment->status !== \App\Models\StockAdjustment::STATUS_APPLIED)
    <!-- Apply Modal -->
    <form method="POST" action="{{ route('stock-adjustments.apply', $adjustment) }}">
        @csrf
        <x-basics.modal show="showApplyModal" title="Appliquer l'ajustement" description="Confirmer l'application de l'ajustement">
            <p>Voulez-vous vraiment appliquer cet ajustement de stock ?</p>
            <p class="text-sm text-gray-600 mt-2">
                Les quantités des produits seront {{ $adjustment->type === 'increase' ? 'augmentées' : 'diminuées' }} immédiatement.
            </p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <x-basics.button type="submit" variant="success" class="w-full">
                        <i class="ph ph-check-circle mr-2"></i>
                        Appliquer
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>

    <!-- Delete Modal -->
    <form method="POST" action="{{ route('stock-adjustments.destroy', $adjustment) }}">
        @csrf
        @method('DELETE')
        <x-basics.modal show="showDeleteModal" title="Supprimer l'ajustement" description="Confirmer la suppression">
            <p>Voulez-vous vraiment supprimer cet ajustement ?</p>
            <p class="text-sm text-red-600 mt-2">Cette action est irréversible.</p>

            @slot('footer')
                <div class="flex justify-end gap-3">
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        <i class="ph ph-trash mr-2"></i>
                        Supprimer
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
    @endif
</div>


