@props(['sale'])

<div x-data="{ showCancelModal: false }">

    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye"
                href="{{ route('sales.show', $sale) }}">
                Voir les détails
            </x-basics.dropdown-item>

            @if ($sale->status === \App\Models\Sale::STATUS_COMPLETED)
                <x-basics.dropdown-item icon="ph ph-printer"
                    href="{{ route('sales.print', $sale) }}" target="_blank">
                    Imprimer la facture
                </x-basics.dropdown-item>
            @endif

            <x-basics.dropdown-separator />

            <x-basics.dropdown-item icon="ph ph-pencil"
                href="{{ route('sales.edit', $sale) }}">
                Modifier
            </x-basics.dropdown-item>

            @if ($sale->status === \App\Models\Sale::STATUS_COMPLETED)
                <x-basics.dropdown-separator />

				<x-basics.dropdown-item icon="ph ph-x-circle" variant="danger" @click="showCancelModal = true">
					Annuler la vente
				</x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

	@if ($sale->status === \App\Models\Sale::STATUS_COMPLETED)
		<form action="{{ route('sales.cancel', $sale) }}" method="POST">
			@csrf
			@method('PUT')

			<x-basics.modal show="showCancelModal" title="Annuler la vente" description="">
				<p>Voulez-vous vraiment annuler la vente ?</p>
				<p class="text-sm text-red-500">Cette action est irréversible.</p>

				<div class="mt-3 text-gray-600 text-sm">
					<p>En annulant cette vente :</p>
					<ul class="list-disc list-inside mt-1">
						<li>L'argent encaissé sera retiré du total de la caisse.</li>
						<li>Le stock des produits vendus sera réajusté et les articles remis en stock.</li>
					</ul>
				</div>

				@slot('footer')
					<x-basics.button type="submit" variant="danger" class="w-full">
						Annuler la vente
					</x-basics.button>
				@endslot
			</x-basics.modal>
		</form>
	@endif

</div>
