@props(['purchaseOrder'])

<div class="space-y-6">
    <x-basics.card title="Informations" subtitle="Détails du bon de commande">
        <div class="space-y-3">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                {!! $purchaseOrder->getStatusBadge() !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Référence:</span>
                <span class="text-sm font-medium">{{ $purchaseOrder->reference }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Date de commande:</span>
                <span class="text-sm">{{ $purchaseOrder->order_date->format('d M Y') }}</span>
            </div>

            @if ($purchaseOrder->expected_delivery_date)
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Date de livraison prévue:</span>
                    <span class="text-sm">{{ $purchaseOrder->expected_delivery_date->format('d M Y') }}</span>
                </div>
            @endif

            @if ($purchaseOrder->submitted_at)
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Soumis le:</span>
                    <span class="text-sm">{{ $purchaseOrder->submitted_at->format('d M Y H:i') }}</span>
                </div>
            @endif

            @if ($purchaseOrder->received_at)
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Reçu le:</span>
                    <span class="text-sm">{{ $purchaseOrder->received_at->format('d M Y H:i') }}</span>
                </div>
            @endif

            @if ($purchaseOrder->cancelled_at)
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-600">Annulé le:</span>
                    <span class="text-sm">{{ $purchaseOrder->cancelled_at->format('d M Y H:i') }}</span>
                </div>
            @endif

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Nombre d'articles:</span>
                <span class="text-sm font-medium">{{ $purchaseOrder->items->count() }}</span>
            </div>
        </div>
    </x-basics.card>

    <!-- Purchase Order Information -->
    <x-basics.card title="À propos des Bons de Commande" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-receipt text-blue-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Les bons de commande</strong> formalisent vos achats auprès des fournisseurs.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-buildings text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Les fournisseurs</strong> reçoivent ces documents pour préparer vos commandes.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-package text-purple-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>La réception</strong> transforme les commandes en entrées de stock.
                </p>
            </div>
        </div>
    </x-basics.card>

    <!-- Purchase Order Management -->
    <x-basics.card title="Gestion des Commandes" bodyBg="bg-green-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-check-circle text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Vérifiez les informations :</strong> Fournisseur, articles, quantités et prix avant validation.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-edit text-blue-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Statut du bon :</strong> Modifiable en brouillon, figé une fois validé.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-hash text-purple-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Référence unique :</strong> Facilite le suivi et l'archivage des commandes.
                </p>
            </div>
        </div>
    </x-basics.card>
</div>
