@props(['product'])

<div class="space-y-6">
    <x-basics.card title="Statut" subtitle="Statut général et stock du produit">
        <div class="space-y-3">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut général:</span>
                {!! $product->getStatusBadge() !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Stock:</span>
                {!! $product->getStockStatusBadge() !!}
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Stock actuel:</span>
                <span class="text-sm font-medium">{{ $product->current_stock ?? 0 }} {{ Str::plural(strtolower($product->saleUnit?->name ?? 'unité'), $product->current_stock) }}</span>
            </div>


            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Seuil de réapprovisionnement:</span>
                <span class="text-sm font-medium">{{ $product->reorder_level ?? 0 }} {{ Str::plural(strtolower($product->saleUnit?->name ?? 'unité'), $product->reorder_level) }}</span>
            </div>

        </div>
    </x-basics.card>

    <!-- Product Fields (combined card) -->
    <x-basics.card title="Champs du produit" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start space-x-2">
                <i class="ph ph-text-aa text-blue-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Nom</strong> : Libellé affiché lors des ventes et dans les listes.
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-book text-indigo-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Nom générique</strong> : Référence commune (utile pour les produits pharmaceutiques).
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-barcode text-amber-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>SKU (Code produit)</strong> : Identifiant unique pour le suivi des stocks et la gestion.
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-folders text-teal-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Catégorie</strong> : Classe le produit pour faciliter le filtrage et les rapports.
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-arrows-left-right text-emerald-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Unité d'achat</strong> : Unité dans laquelle vous achetez (ex. boîte).
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-currency-circle-dollar text-green-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>P.A. ou Prix d'achat</strong> : Coût par unité d'achat.
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-scales text-purple-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Unité de vente</strong> : Unité vendue au client (ex. pièce).
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-tag text-pink-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>P.V. ou Prix de vente</strong> : Prix final par unité de vente.
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-arrows-in-line-horizontal text-sky-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Facteur de conversion</strong> : Nombre d’unités de vente dans 1 unité d’achat (ex. 1 boîte = 10 pièces).
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-warning text-orange-600 mt-0.5"></i>
                <p class="text-gray-600">
                    <strong>Seuil de réapprovisionnement</strong> : Seuil d’alerte quand le stock devient faible en unité de vente.
                </p>
            </div>

        </div>
    </x-basics.card>
</div>

