@props(['product'])

<div x-data="{ showDeleteModal: false, showActivateModal: false, showDeactivateModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('products.show', $product) }}">
                Voir
            </x-basics.dropdown-item>

            @if($product->status == \App\Models\Product::STATUS_INACTIVE)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('products.edit', $product) }}">
                    Modifier
                </x-basics.dropdown-item>
            @endif

            @if ($product->status == \App\Models\Product::STATUS_ACTIVE)
                <x-basics.dropdown-item icon="ph ph-pause-circle" variant="warning" @click="showDeactivateModal = true">
                    Désactiver
                </x-basics.dropdown-item>
            @else
                <x-basics.dropdown-item icon="ph ph-play-circle" variant="success" @click="showActivateModal = true">
                    Activer
                </x-basics.dropdown-item>
            @endif

            @if($product->status == \App\Models\Product::STATUS_INACTIVE)
            <x-basics.dropdown-separator />
            <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                Supprimer
            </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    @if($product->status == \App\Models\Product::STATUS_INACTIVE)
    <!-- Activation Modal -->
    <x-basics.modal show="showActivateModal" title="Activer le produit" description="Confirmer l'activation du produit">
        <p>Voulez-vous vraiment activer ce produit ?</p>
        <p class="text-sm text-gray-600 mt-2">
            Le produit sera disponible pour les ventes et les opérations de stock.
        </p>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('products.activate', $product) }}" class="inline w-full">
                    @csrf
                    <x-basics.button type="submit" variant="success" class="w-full">
                        <i class="ph ph-play-circle mr-2"></i>
                        Activer
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>
    @endif

    @if($product->status == \App\Models\Product::STATUS_ACTIVE)
    <!-- Deactivation Modal -->
    <x-basics.modal show="showDeactivateModal" title="Désactiver le produit"
        description="Confirmer la désactivation du produit">
        <p>Voulez-vous vraiment désactiver ce produit ?</p>
        <p class="text-sm text-gray-600 mt-2">
            Le produit ne sera plus disponible pour les nouvelles ventes, mais les ventes existantes resteront intactes.
        </p>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('products.deactivate', $product) }}" class="inline w-full">
                    @csrf
                    <x-basics.button type="submit" variant="warning" class="w-full">
                        <i class="ph ph-pause-circle mr-2"></i>
                        Désactiver
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>
    @endif

    @if($product->status == \App\Models\Product::STATUS_INACTIVE)
    <!-- Delete Modal -->
    <x-basics.modal show="showDeleteModal" title="Supprimer le produit"
        description="Confirmer la suppression du produit">
        <p>Voulez-vous vraiment supprimer ce produit ?</p>
        <p class="text-sm text-red-500 mt-2">Cette action est irréversible.</p>

        <div class="mt-3 text-gray-600 text-sm">
            <p>En supprimant ce produit :</p>
            <ul class="list-disc list-inside mt-1">
                <li>Toutes les données associées seront perdues</li>
                <li>Cette action ne peut pas être annulée</li>
            </ul>
        </div>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('products.destroy', $product) }}" class="inline w-full">
                    @csrf
                    @method('DELETE')
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        <i class="ph ph-trash mr-2"></i>
                        Supprimer
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>
    @endif
</div>
