@props(['prescription' => null])

<div class="space-y-6">
    @if($prescription)
        <!-- Prescription Status -->
        <x-basics.card title="Statut de la Prescription">
            <div class="space-y-3 text-sm">
                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Statut:</span>
                    {!! \App\Models\Prescription::getStatusBadge(data_get($prescription, 'status')) !!}
                </div>

                @if (data_get($prescription, 'submitted_at'))
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Soumis le:</span>
                        <span class="font-medium">
                            {{ \Carbon\Carbon::parse(data_get($prescription, 'submitted_at'))->format('d/m/Y H:i') }}
                        </span>
                    </div>
                @endif


                @if (!empty(data_get($prescription, 'products', [])))
                    <div class="border-t pt-3">
                        <div class="flex items-center justify-between">
                            <span class="font-bold text-gray-900">Produits:</span>
                            <span class="font-bold text-gray-900">{{ count(data_get($prescription, 'products', [])) }}</span>
                        </div>
                    </div>
                @endif
            </div>
        </x-basics.card>

        <!-- Doctor Information -->
        @if (data_get($prescription, 'doctor.name'))
            <x-basics.card title="Informations Médecin">
                <div class="space-y-3 text-sm">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Nom:</span>
                        <span class="font-medium">{{ data_get($prescription, 'doctor.name') }}</span>
                    </div>

                    @if (data_get($prescription, 'doctor.cnom'))
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">CNOM:</span>
                            <span class="font-medium">{{ data_get($prescription, 'doctor.cnom') }}</span>
                        </div>
                    @endif

                    @if (data_get($prescription, 'doctor.qualification'))
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Qualification:</span>
                            <span class="font-medium capitalize">
                                {{ str_replace('_', ' ', data_get($prescription, 'doctor.qualification')) }}
                            </span>
                        </div>
                    @endif
                </div>
            </x-basics.card>
        @endif

    @endif

    <!-- Prescription Management -->
    <x-basics.card title="Gestion des Prescriptions" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm">
            <div class="flex items-center space-x-2">
                <i class="ph ph-prescription text-blue-600"></i>
                <span class="text-gray-600">Suivi des ordres</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-check-circle text-green-600"></i>
                <span class="text-gray-600">Approbation des prescriptions</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-chat-circle text-purple-600"></i>
                <span class="text-gray-600">Communication client</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-map-pin text-orange-600"></i>
                <span class="text-gray-600">Géolocalisation</span>
            </div>
        </div>
    </x-basics.card>

    <!-- Tips -->
    <x-basics.card title="Conseils d'Utilisation" bodyBg="bg-yellow-50">
        <div class="space-y-3 text-sm">
            <p class="text-gray-600 text-justify">
                <strong>Approbation rapide :</strong> Vérifiez les prescriptions en attente régulièrement pour maintenir
                un bon service client et répondre rapidement aux demandes.
            </p>
            <p class="text-gray-600 text-justify">
                <strong>Communication :</strong> Utilisez la fonctionnalité de contact client pour clarifier
                les besoins et améliorer la satisfaction client.
            </p>
            <p class="text-gray-600 text-justify">
                <strong>Géolocalisation :</strong> Utilisez les coordonnées GPS pour planifier les livraisons
                et optimiser les itinéraires.
            </p>
        </div>
    </x-basics.card>
    
</div>

