@props(['paymentMethod'])

<div x-data="{ showDeleteModal: false, showDeactivateModal: false, showActivateModal: false }">

    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('payment-methods.show', $paymentMethod) }}" wire:navigate>
                Voir
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('payment-methods.edit', $paymentMethod) }}" wire:navigate>
                Modifier
            </x-basics.dropdown-item>

            @if ($paymentMethod->status)
                <x-basics.dropdown-item icon="ph ph-pause-circle" variant="warning" @click="showDeactivateModal = true">
                    Désactiver
                </x-basics.dropdown-item>
            @else
                <x-basics.dropdown-item icon="ph ph-play-circle" variant="success" @click="showActivateModal = true">
                    Activer
                </x-basics.dropdown-item>
            @endif

            @if (! $paymentMethod->status)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    <!-- Deactivate Modal -->
    <x-basics.modal show="showDeactivateModal" title="Désactiver la méthode de paiement" description="Confirmer la désactivation">
        <p>Voulez-vous vraiment désactiver cette méthode de paiement ?</p>
        <p class="text-sm text-yellow-600 mt-2">Elle ne sera plus disponible dans les nouvelles ventes.</p>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('payment-methods.deactivate', $paymentMethod) }}" class="inline w-full">
                    @csrf
                    <x-basics.button type="submit" variant="warning" class="w-full">
                        <i class="ph ph-pause-circle mr-2"></i>
                        Désactiver
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>

    <!-- Activate Modal -->
    <x-basics.modal show="showActivateModal" title="Activer la méthode de paiement" description="Confirmer l'activation">
        <p>Voulez-vous vraiment activer cette méthode de paiement ?</p>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('payment-methods.activate', $paymentMethod) }}" class="inline w-full">
                    @csrf
                    <x-basics.button type="submit" variant="success" class="w-full">
                        <i class="ph ph-check-circle mr-2"></i>
                        Activer
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>

    <!-- Delete Modal -->
    <x-basics.modal show="showDeleteModal" title="Supprimer la méthode de paiement" description="Confirmer la suppression">
        <p>Voulez-vous vraiment supprimer cette méthode de paiement ?</p>
        <p class="text-sm text-red-500 mt-2">Cette action est irréversible.</p>

        @slot('footer')
            <div class="flex justify-end gap-3">
                <form method="POST" action="{{ route('payment-methods.destroy', $paymentMethod) }}" class="inline w-full">
                    @csrf
                    @method('DELETE')
                    <x-basics.button type="submit" variant="danger" class="w-full">
                        <i class="ph ph-trash mr-2"></i>
                        Supprimer
                    </x-basics.button>
                </form>
            </div>
        @endslot
    </x-basics.modal>

</div>


