@php
    $merchant = \App\Models\Setting::first(['merchant_status', 'merchant_type', 'merchant_created_at']);
@endphp

<div class="space-y-6">
    <!-- Merchant Status -->
    <x-basics.card title="Statut de l'Établissement">
        <div class="space-y-3 text-sm">
            <div class="flex items-center justify-between">
                <span class="text-gray-600">Statut:</span>
                {!! \App\Models\Merchant::getStatusBadge($merchant->merchant_status) !!}
            </div>
            <div class="flex items-center justify-between">
                <span class="text-gray-600">Type:</span>
                <span class="text-gray-900">{!! \App\Models\Merchant::getTypeBadge($merchant->merchant_type) !!}</span>
            </div>

            @if($merchant->merchant_created_at)
                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Créé le:</span>
                    <span class="font-medium">{{ \Carbon\Carbon::parse($merchant->merchant_created_at)->format('d/m/Y') }}</span>
                </div>
            @endif

            @if($merchant->updated_at)
            <div class="flex items-center justify-between">
                <span class="text-gray-600">Modifié le:</span>
                <span class="font-medium">{{ \Carbon\Carbon::parse($merchant->updated_at)->format('d/m/Y') }}</span>
            </div>
        @endif

        </div>
    </x-basics.card>

    <!-- About Merchants -->
    <x-basics.card title="À propos de l'Établissement" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm">
            <div class="flex items-start space-x-2">
                <i class="ph ph-info text-blue-600 mt-0.5"></i>
                <p class="text-gray-600 text-justify">
                    Votre établissement représente votre pharmacie ou dépôt pharmaceutique dans le système.
                    Il contient toutes les informations essentielles pour votre activité professionnelle.
                </p>
            </div>
            
            <div class="flex items-start space-x-2">
                <i class="ph ph-map-pin text-green-600 mt-0.5"></i>
                <p class="text-gray-600 text-justify">
                    <strong>Localisation:</strong> La position géographique permet de vous envoyer des commandes 
                    et des prescriptions de clients situés à proximité de votre établissement.
                </p>
            </div>

            <div class="flex items-start space-x-2">
                <i class="ph ph-identification-card text-purple-600 mt-0.5"></i>
                <p class="text-gray-600 text-justify">
                    <strong>CNOP:</strong> Le Conseil National de l'Ordre des Pharmaciens est votre numéro 
                    d'ordre professionnel qui vous identifie de manière unique dans le système de santé.
                </p>
            </div>
        </div>
    </x-basics.card>

    <!-- Required Information -->
    <x-basics.card title="Activation de l'Établissement" bodyBg="bg-yellow-50">
        <div class="space-y-3 text-sm">
            <div class="flex items-start space-x-2">
                <i class="ph ph-check-circle text-green-600 mt-0.5"></i>
                <p class="text-gray-600 text-justify">
                    <strong>Informations requises pour l'activation:</strong>
                </p>
            </div>
            
            <ul class="list-disc list-inside text-gray-600 space-y-1 ml-4">
                <li>Nom de l'établissement</li>
                <li>Type d'établissement (Pharmacie/Dépôt)</li>
                <li>Téléphone de contact</li>
                <li>Province et ville</li>
                <li>Connexion internet active</li>
            </ul>

            <div class="flex items-start space-x-2 mt-3 pt-3 border-t border-yellow-200">
                <i class="ph ph-warning text-orange-600 mt-0.5"></i>
                <p class="text-gray-600 text-justify">
                    Une fois activé, les informations de l'établissement ne pourront plus être modifiées 
                    sans désactivation préalable.
                </p>
            </div>
        </div>
    </x-basics.card>


    <!-- Tips -->
    <x-basics.card title="Conseils d'Utilisation" bodyBg="bg-yellow-50">
        <div class="space-y-3 text-sm">
            <p class="text-gray-600 text-justify">
                <strong>Vérification :</strong> Vérifiez toutes les informations avant d'activer votre établissement.
                Une fois activé, certaines modifications peuvent être limitées.
            </p>
            <p class="text-gray-600 text-justify">
                <strong>Sécurité :</strong> Gardez vos documents professionnels à jour et assurez-vous
                que toutes les informations de contact sont exactes.
            </p>
            <p class="text-gray-600 text-justify">
                <strong>Conformité :</strong> Respectez les réglementations en vigueur pour votre type d'établissement
                et maintenez votre CNOP à jour.
            </p>
        </div>
    </x-basics.card>
</div> 