<div x-data="{ showDeleteModal: false, showActivateModal: false, showDeactivateModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('merchant.show') }}" wire:navigate>
                Voir
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('merchant.edit') }}" wire:navigate>
                Modifier
            </x-basics.dropdown-item>

            <x-basics.dropdown-separator />

            @if (settings('merchant_status'))
                <x-basics.dropdown-item icon="ph ph-pause-circle" variant="danger" type="submit"
                    @click="showDeactivateModal = true">
                    Désactiver
                </x-basics.dropdown-item>
            @else
                <x-basics.dropdown-item icon="ph ph-play-circle" variant="success" type="submit"
                    @click="showActivateModal = true">
                    Activer
                </x-basics.dropdown-item>
            @endif

        </x-slot>
    </x-basics.dropdown>


    @if (settings('merchant_status'))
        <!-- Deactivate Modal -->
        <x-basics.modal show="showDeactivateModal" title="Désactiver l'établissement" description="">
            <livewire:merchant.modal-deactivate />
        </x-basics.modal>
    @else
        <!-- Activate Modal -->
        <x-basics.modal show="showActivateModal" title="Activer l'établissement" description="">
            <livewire:merchant.modal-activate />
        </x-basics.modal>
    @endif
</div>
